//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_60_sb_w            = 8;
  parameter vitAcs_60_pmIn0_w         = 9;
  parameter vitAcs_60_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_60_sel_w           = 1;
  parameter vitAcs_60_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_60_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_60_i0              = 1;
  parameter vitAcs_60_i1              = 0;
  parameter vitAcs_60_pbrv            = 412;
  parameter vitAcs_60_ws              = 4;
  parameter vitAcs_60_wp              = 9;

  // Iregs
  parameter vitAcs_60_pmBuf_w         = 9;
  parameter vitAcs_60_pmBuf_n         = 1;
  parameter vitAcs_60_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_60.sb_w            = vitAcs_60_sb_w;
  defparam vitAcs_60.pmIn0_w         = vitAcs_60_pmIn0_w;
  defparam vitAcs_60.pmIn1_w         = vitAcs_60_pmIn1_w;
  defparam vitAcs_60.sel_w           = vitAcs_60_sel_w;
  defparam vitAcs_60.pmOut_w         = vitAcs_60_pmOut_w;
  defparam vitAcs_60.run1_w          = vitAcs_60_run1_w;
  defparam vitAcs_60.i0              = vitAcs_60_i0;
  defparam vitAcs_60.i1              = vitAcs_60_i1;
  defparam vitAcs_60.pbrv            = vitAcs_60_pbrv;
  defparam vitAcs_60.ws              = vitAcs_60_ws;
  defparam vitAcs_60.wp              = vitAcs_60_wp;
  defparam vitAcs_60.pmBuf_w         = vitAcs_60_pmBuf_w;
  defparam vitAcs_60.pmBuf_n         = vitAcs_60_pmBuf_n;
  defparam vitAcs_60.pmBuf_m         = vitAcs_60_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_60_sel_w-1:0]  vitAcs_60_sel;
  wire                                      vitAcs_60_sel_or;
  wire                                      vitAcs_60_sel_ff;
  wire                                      vitAcs_60_sel_we;

  wire             [vitAcs_60_pmOut_w-1:0]  vitAcs_60_pmOut;
  wire                                      vitAcs_60_pmOut_or;
  wire                                      vitAcs_60_pmOut_ff;
  wire                                      vitAcs_60_pmOut_we;

  wire                [vitAcs_60_sb_w-1:0]  vitAcs_60_sb;
  wire                                      vitAcs_60_sb_ir;
  wire                                      vitAcs_60_sb_fe;
  wire                                      vitAcs_60_sb_re;

  wire             [vitAcs_60_pmIn0_w-1:0]  vitAcs_60_pmIn0;
  wire                                      vitAcs_60_pmIn0_ir;
  wire                                      vitAcs_60_pmIn0_fe;
  wire                                      vitAcs_60_pmIn0_re;

  wire             [vitAcs_60_pmIn1_w-1:0]  vitAcs_60_pmIn1;
  wire                                      vitAcs_60_pmIn1_ir;
  wire                                      vitAcs_60_pmIn1_fe;
  wire                                      vitAcs_60_pmIn1_re;

  wire              [vitAcs_60_run1_w-1:0]  vitAcs_60_run1;

  wire                                      vitAcs_60_regWe;
  wire                                      vitAcs_60_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_60(vitAcs_60_sel, vitAcs_60_sel_or, vitAcs_60_sel_ff, vitAcs_60_sel_we,
                   vitAcs_60_pmOut, vitAcs_60_pmOut_or, vitAcs_60_pmOut_ff, vitAcs_60_pmOut_we,
                   vitAcs_60_sb, vitAcs_60_sb_ir, vitAcs_60_sb_fe, vitAcs_60_sb_re, 
                   vitAcs_60_pmIn0, vitAcs_60_pmIn0_ir, vitAcs_60_pmIn0_fe, vitAcs_60_pmIn0_re, 
                   vitAcs_60_pmIn1, vitAcs_60_pmIn1_ir, vitAcs_60_pmIn1_fe, vitAcs_60_pmIn1_re, 
                   vitAcs_60_run1, 
                   regBus, regWe, regRe, vitAcs_60_regWe, vitAcs_60_regRe, clk, clk2, reset);


//==============================================================================
