//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_59_sb_w            = 8;
  parameter vitAcs_59_pmIn0_w         = 9;
  parameter vitAcs_59_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_59_sel_w           = 1;
  parameter vitAcs_59_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_59_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_59_i0              = 1;
  parameter vitAcs_59_i1              = 1;
  parameter vitAcs_59_pbrv            = 412;
  parameter vitAcs_59_ws              = 4;
  parameter vitAcs_59_wp              = 9;

  // Iregs
  parameter vitAcs_59_pmBuf_w         = 9;
  parameter vitAcs_59_pmBuf_n         = 1;
  parameter vitAcs_59_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_59.sb_w            = vitAcs_59_sb_w;
  defparam vitAcs_59.pmIn0_w         = vitAcs_59_pmIn0_w;
  defparam vitAcs_59.pmIn1_w         = vitAcs_59_pmIn1_w;
  defparam vitAcs_59.sel_w           = vitAcs_59_sel_w;
  defparam vitAcs_59.pmOut_w         = vitAcs_59_pmOut_w;
  defparam vitAcs_59.run1_w          = vitAcs_59_run1_w;
  defparam vitAcs_59.i0              = vitAcs_59_i0;
  defparam vitAcs_59.i1              = vitAcs_59_i1;
  defparam vitAcs_59.pbrv            = vitAcs_59_pbrv;
  defparam vitAcs_59.ws              = vitAcs_59_ws;
  defparam vitAcs_59.wp              = vitAcs_59_wp;
  defparam vitAcs_59.pmBuf_w         = vitAcs_59_pmBuf_w;
  defparam vitAcs_59.pmBuf_n         = vitAcs_59_pmBuf_n;
  defparam vitAcs_59.pmBuf_m         = vitAcs_59_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_59_sel_w-1:0]  vitAcs_59_sel;
  wire                                      vitAcs_59_sel_or;
  wire                                      vitAcs_59_sel_ff;
  wire                                      vitAcs_59_sel_we;

  wire             [vitAcs_59_pmOut_w-1:0]  vitAcs_59_pmOut;
  wire                                      vitAcs_59_pmOut_or;
  wire                                      vitAcs_59_pmOut_ff;
  wire                                      vitAcs_59_pmOut_we;

  wire                [vitAcs_59_sb_w-1:0]  vitAcs_59_sb;
  wire                                      vitAcs_59_sb_ir;
  wire                                      vitAcs_59_sb_fe;
  wire                                      vitAcs_59_sb_re;

  wire             [vitAcs_59_pmIn0_w-1:0]  vitAcs_59_pmIn0;
  wire                                      vitAcs_59_pmIn0_ir;
  wire                                      vitAcs_59_pmIn0_fe;
  wire                                      vitAcs_59_pmIn0_re;

  wire             [vitAcs_59_pmIn1_w-1:0]  vitAcs_59_pmIn1;
  wire                                      vitAcs_59_pmIn1_ir;
  wire                                      vitAcs_59_pmIn1_fe;
  wire                                      vitAcs_59_pmIn1_re;

  wire              [vitAcs_59_run1_w-1:0]  vitAcs_59_run1;

  wire                                      vitAcs_59_regWe;
  wire                                      vitAcs_59_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_59(vitAcs_59_sel, vitAcs_59_sel_or, vitAcs_59_sel_ff, vitAcs_59_sel_we,
                   vitAcs_59_pmOut, vitAcs_59_pmOut_or, vitAcs_59_pmOut_ff, vitAcs_59_pmOut_we,
                   vitAcs_59_sb, vitAcs_59_sb_ir, vitAcs_59_sb_fe, vitAcs_59_sb_re, 
                   vitAcs_59_pmIn0, vitAcs_59_pmIn0_ir, vitAcs_59_pmIn0_fe, vitAcs_59_pmIn0_re, 
                   vitAcs_59_pmIn1, vitAcs_59_pmIn1_ir, vitAcs_59_pmIn1_fe, vitAcs_59_pmIn1_re, 
                   vitAcs_59_run1, 
                   regBus, regWe, regRe, vitAcs_59_regWe, vitAcs_59_regRe, clk, clk2, reset);


//==============================================================================
