//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_58_sb_w            = 8;
  parameter vitAcs_58_pmIn0_w         = 9;
  parameter vitAcs_58_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_58_sel_w           = 1;
  parameter vitAcs_58_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_58_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_58_i0              = 0;
  parameter vitAcs_58_i1              = 0;
  parameter vitAcs_58_pbrv            = 412;
  parameter vitAcs_58_ws              = 4;
  parameter vitAcs_58_wp              = 9;

  // Iregs
  parameter vitAcs_58_pmBuf_w         = 9;
  parameter vitAcs_58_pmBuf_n         = 1;
  parameter vitAcs_58_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_58.sb_w            = vitAcs_58_sb_w;
  defparam vitAcs_58.pmIn0_w         = vitAcs_58_pmIn0_w;
  defparam vitAcs_58.pmIn1_w         = vitAcs_58_pmIn1_w;
  defparam vitAcs_58.sel_w           = vitAcs_58_sel_w;
  defparam vitAcs_58.pmOut_w         = vitAcs_58_pmOut_w;
  defparam vitAcs_58.run1_w          = vitAcs_58_run1_w;
  defparam vitAcs_58.i0              = vitAcs_58_i0;
  defparam vitAcs_58.i1              = vitAcs_58_i1;
  defparam vitAcs_58.pbrv            = vitAcs_58_pbrv;
  defparam vitAcs_58.ws              = vitAcs_58_ws;
  defparam vitAcs_58.wp              = vitAcs_58_wp;
  defparam vitAcs_58.pmBuf_w         = vitAcs_58_pmBuf_w;
  defparam vitAcs_58.pmBuf_n         = vitAcs_58_pmBuf_n;
  defparam vitAcs_58.pmBuf_m         = vitAcs_58_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_58_sel_w-1:0]  vitAcs_58_sel;
  wire                                      vitAcs_58_sel_or;
  wire                                      vitAcs_58_sel_ff;
  wire                                      vitAcs_58_sel_we;

  wire             [vitAcs_58_pmOut_w-1:0]  vitAcs_58_pmOut;
  wire                                      vitAcs_58_pmOut_or;
  wire                                      vitAcs_58_pmOut_ff;
  wire                                      vitAcs_58_pmOut_we;

  wire                [vitAcs_58_sb_w-1:0]  vitAcs_58_sb;
  wire                                      vitAcs_58_sb_ir;
  wire                                      vitAcs_58_sb_fe;
  wire                                      vitAcs_58_sb_re;

  wire             [vitAcs_58_pmIn0_w-1:0]  vitAcs_58_pmIn0;
  wire                                      vitAcs_58_pmIn0_ir;
  wire                                      vitAcs_58_pmIn0_fe;
  wire                                      vitAcs_58_pmIn0_re;

  wire             [vitAcs_58_pmIn1_w-1:0]  vitAcs_58_pmIn1;
  wire                                      vitAcs_58_pmIn1_ir;
  wire                                      vitAcs_58_pmIn1_fe;
  wire                                      vitAcs_58_pmIn1_re;

  wire              [vitAcs_58_run1_w-1:0]  vitAcs_58_run1;

  wire                                      vitAcs_58_regWe;
  wire                                      vitAcs_58_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_58(vitAcs_58_sel, vitAcs_58_sel_or, vitAcs_58_sel_ff, vitAcs_58_sel_we,
                   vitAcs_58_pmOut, vitAcs_58_pmOut_or, vitAcs_58_pmOut_ff, vitAcs_58_pmOut_we,
                   vitAcs_58_sb, vitAcs_58_sb_ir, vitAcs_58_sb_fe, vitAcs_58_sb_re, 
                   vitAcs_58_pmIn0, vitAcs_58_pmIn0_ir, vitAcs_58_pmIn0_fe, vitAcs_58_pmIn0_re, 
                   vitAcs_58_pmIn1, vitAcs_58_pmIn1_ir, vitAcs_58_pmIn1_fe, vitAcs_58_pmIn1_re, 
                   vitAcs_58_run1, 
                   regBus, regWe, regRe, vitAcs_58_regWe, vitAcs_58_regRe, clk, clk2, reset);


//==============================================================================
