//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_57_sb_w            = 8;
  parameter vitAcs_57_pmIn0_w         = 9;
  parameter vitAcs_57_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_57_sel_w           = 1;
  parameter vitAcs_57_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_57_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_57_i0              = 1;
  parameter vitAcs_57_i1              = 0;
  parameter vitAcs_57_pbrv            = 412;
  parameter vitAcs_57_ws              = 4;
  parameter vitAcs_57_wp              = 9;

  // Iregs
  parameter vitAcs_57_pmBuf_w         = 9;
  parameter vitAcs_57_pmBuf_n         = 1;
  parameter vitAcs_57_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_57.sb_w            = vitAcs_57_sb_w;
  defparam vitAcs_57.pmIn0_w         = vitAcs_57_pmIn0_w;
  defparam vitAcs_57.pmIn1_w         = vitAcs_57_pmIn1_w;
  defparam vitAcs_57.sel_w           = vitAcs_57_sel_w;
  defparam vitAcs_57.pmOut_w         = vitAcs_57_pmOut_w;
  defparam vitAcs_57.run1_w          = vitAcs_57_run1_w;
  defparam vitAcs_57.i0              = vitAcs_57_i0;
  defparam vitAcs_57.i1              = vitAcs_57_i1;
  defparam vitAcs_57.pbrv            = vitAcs_57_pbrv;
  defparam vitAcs_57.ws              = vitAcs_57_ws;
  defparam vitAcs_57.wp              = vitAcs_57_wp;
  defparam vitAcs_57.pmBuf_w         = vitAcs_57_pmBuf_w;
  defparam vitAcs_57.pmBuf_n         = vitAcs_57_pmBuf_n;
  defparam vitAcs_57.pmBuf_m         = vitAcs_57_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_57_sel_w-1:0]  vitAcs_57_sel;
  wire                                      vitAcs_57_sel_or;
  wire                                      vitAcs_57_sel_ff;
  wire                                      vitAcs_57_sel_we;

  wire             [vitAcs_57_pmOut_w-1:0]  vitAcs_57_pmOut;
  wire                                      vitAcs_57_pmOut_or;
  wire                                      vitAcs_57_pmOut_ff;
  wire                                      vitAcs_57_pmOut_we;

  wire                [vitAcs_57_sb_w-1:0]  vitAcs_57_sb;
  wire                                      vitAcs_57_sb_ir;
  wire                                      vitAcs_57_sb_fe;
  wire                                      vitAcs_57_sb_re;

  wire             [vitAcs_57_pmIn0_w-1:0]  vitAcs_57_pmIn0;
  wire                                      vitAcs_57_pmIn0_ir;
  wire                                      vitAcs_57_pmIn0_fe;
  wire                                      vitAcs_57_pmIn0_re;

  wire             [vitAcs_57_pmIn1_w-1:0]  vitAcs_57_pmIn1;
  wire                                      vitAcs_57_pmIn1_ir;
  wire                                      vitAcs_57_pmIn1_fe;
  wire                                      vitAcs_57_pmIn1_re;

  wire              [vitAcs_57_run1_w-1:0]  vitAcs_57_run1;

  wire                                      vitAcs_57_regWe;
  wire                                      vitAcs_57_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_57(vitAcs_57_sel, vitAcs_57_sel_or, vitAcs_57_sel_ff, vitAcs_57_sel_we,
                   vitAcs_57_pmOut, vitAcs_57_pmOut_or, vitAcs_57_pmOut_ff, vitAcs_57_pmOut_we,
                   vitAcs_57_sb, vitAcs_57_sb_ir, vitAcs_57_sb_fe, vitAcs_57_sb_re, 
                   vitAcs_57_pmIn0, vitAcs_57_pmIn0_ir, vitAcs_57_pmIn0_fe, vitAcs_57_pmIn0_re, 
                   vitAcs_57_pmIn1, vitAcs_57_pmIn1_ir, vitAcs_57_pmIn1_fe, vitAcs_57_pmIn1_re, 
                   vitAcs_57_run1, 
                   regBus, regWe, regRe, vitAcs_57_regWe, vitAcs_57_regRe, clk, clk2, reset);


//==============================================================================
