//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_55_sb_w            = 8;
  parameter vitAcs_55_pmIn0_w         = 9;
  parameter vitAcs_55_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_55_sel_w           = 1;
  parameter vitAcs_55_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_55_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_55_i0              = 1;
  parameter vitAcs_55_i1              = 1;
  parameter vitAcs_55_pbrv            = 412;
  parameter vitAcs_55_ws              = 4;
  parameter vitAcs_55_wp              = 9;

  // Iregs
  parameter vitAcs_55_pmBuf_w         = 9;
  parameter vitAcs_55_pmBuf_n         = 1;
  parameter vitAcs_55_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_55.sb_w            = vitAcs_55_sb_w;
  defparam vitAcs_55.pmIn0_w         = vitAcs_55_pmIn0_w;
  defparam vitAcs_55.pmIn1_w         = vitAcs_55_pmIn1_w;
  defparam vitAcs_55.sel_w           = vitAcs_55_sel_w;
  defparam vitAcs_55.pmOut_w         = vitAcs_55_pmOut_w;
  defparam vitAcs_55.run1_w          = vitAcs_55_run1_w;
  defparam vitAcs_55.i0              = vitAcs_55_i0;
  defparam vitAcs_55.i1              = vitAcs_55_i1;
  defparam vitAcs_55.pbrv            = vitAcs_55_pbrv;
  defparam vitAcs_55.ws              = vitAcs_55_ws;
  defparam vitAcs_55.wp              = vitAcs_55_wp;
  defparam vitAcs_55.pmBuf_w         = vitAcs_55_pmBuf_w;
  defparam vitAcs_55.pmBuf_n         = vitAcs_55_pmBuf_n;
  defparam vitAcs_55.pmBuf_m         = vitAcs_55_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_55_sel_w-1:0]  vitAcs_55_sel;
  wire                                      vitAcs_55_sel_or;
  wire                                      vitAcs_55_sel_ff;
  wire                                      vitAcs_55_sel_we;

  wire             [vitAcs_55_pmOut_w-1:0]  vitAcs_55_pmOut;
  wire                                      vitAcs_55_pmOut_or;
  wire                                      vitAcs_55_pmOut_ff;
  wire                                      vitAcs_55_pmOut_we;

  wire                [vitAcs_55_sb_w-1:0]  vitAcs_55_sb;
  wire                                      vitAcs_55_sb_ir;
  wire                                      vitAcs_55_sb_fe;
  wire                                      vitAcs_55_sb_re;

  wire             [vitAcs_55_pmIn0_w-1:0]  vitAcs_55_pmIn0;
  wire                                      vitAcs_55_pmIn0_ir;
  wire                                      vitAcs_55_pmIn0_fe;
  wire                                      vitAcs_55_pmIn0_re;

  wire             [vitAcs_55_pmIn1_w-1:0]  vitAcs_55_pmIn1;
  wire                                      vitAcs_55_pmIn1_ir;
  wire                                      vitAcs_55_pmIn1_fe;
  wire                                      vitAcs_55_pmIn1_re;

  wire              [vitAcs_55_run1_w-1:0]  vitAcs_55_run1;

  wire                                      vitAcs_55_regWe;
  wire                                      vitAcs_55_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_55(vitAcs_55_sel, vitAcs_55_sel_or, vitAcs_55_sel_ff, vitAcs_55_sel_we,
                   vitAcs_55_pmOut, vitAcs_55_pmOut_or, vitAcs_55_pmOut_ff, vitAcs_55_pmOut_we,
                   vitAcs_55_sb, vitAcs_55_sb_ir, vitAcs_55_sb_fe, vitAcs_55_sb_re, 
                   vitAcs_55_pmIn0, vitAcs_55_pmIn0_ir, vitAcs_55_pmIn0_fe, vitAcs_55_pmIn0_re, 
                   vitAcs_55_pmIn1, vitAcs_55_pmIn1_ir, vitAcs_55_pmIn1_fe, vitAcs_55_pmIn1_re, 
                   vitAcs_55_run1, 
                   regBus, regWe, regRe, vitAcs_55_regWe, vitAcs_55_regRe, clk, clk2, reset);


//==============================================================================
