//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_52_sb_w            = 8;
  parameter vitAcs_52_pmIn0_w         = 9;
  parameter vitAcs_52_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_52_sel_w           = 1;
  parameter vitAcs_52_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_52_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_52_i0              = 0;
  parameter vitAcs_52_i1              = 1;
  parameter vitAcs_52_pbrv            = 412;
  parameter vitAcs_52_ws              = 4;
  parameter vitAcs_52_wp              = 9;

  // Iregs
  parameter vitAcs_52_pmBuf_w         = 9;
  parameter vitAcs_52_pmBuf_n         = 1;
  parameter vitAcs_52_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_52.sb_w            = vitAcs_52_sb_w;
  defparam vitAcs_52.pmIn0_w         = vitAcs_52_pmIn0_w;
  defparam vitAcs_52.pmIn1_w         = vitAcs_52_pmIn1_w;
  defparam vitAcs_52.sel_w           = vitAcs_52_sel_w;
  defparam vitAcs_52.pmOut_w         = vitAcs_52_pmOut_w;
  defparam vitAcs_52.run1_w          = vitAcs_52_run1_w;
  defparam vitAcs_52.i0              = vitAcs_52_i0;
  defparam vitAcs_52.i1              = vitAcs_52_i1;
  defparam vitAcs_52.pbrv            = vitAcs_52_pbrv;
  defparam vitAcs_52.ws              = vitAcs_52_ws;
  defparam vitAcs_52.wp              = vitAcs_52_wp;
  defparam vitAcs_52.pmBuf_w         = vitAcs_52_pmBuf_w;
  defparam vitAcs_52.pmBuf_n         = vitAcs_52_pmBuf_n;
  defparam vitAcs_52.pmBuf_m         = vitAcs_52_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_52_sel_w-1:0]  vitAcs_52_sel;
  wire                                      vitAcs_52_sel_or;
  wire                                      vitAcs_52_sel_ff;
  wire                                      vitAcs_52_sel_we;

  wire             [vitAcs_52_pmOut_w-1:0]  vitAcs_52_pmOut;
  wire                                      vitAcs_52_pmOut_or;
  wire                                      vitAcs_52_pmOut_ff;
  wire                                      vitAcs_52_pmOut_we;

  wire                [vitAcs_52_sb_w-1:0]  vitAcs_52_sb;
  wire                                      vitAcs_52_sb_ir;
  wire                                      vitAcs_52_sb_fe;
  wire                                      vitAcs_52_sb_re;

  wire             [vitAcs_52_pmIn0_w-1:0]  vitAcs_52_pmIn0;
  wire                                      vitAcs_52_pmIn0_ir;
  wire                                      vitAcs_52_pmIn0_fe;
  wire                                      vitAcs_52_pmIn0_re;

  wire             [vitAcs_52_pmIn1_w-1:0]  vitAcs_52_pmIn1;
  wire                                      vitAcs_52_pmIn1_ir;
  wire                                      vitAcs_52_pmIn1_fe;
  wire                                      vitAcs_52_pmIn1_re;

  wire              [vitAcs_52_run1_w-1:0]  vitAcs_52_run1;

  wire                                      vitAcs_52_regWe;
  wire                                      vitAcs_52_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_52(vitAcs_52_sel, vitAcs_52_sel_or, vitAcs_52_sel_ff, vitAcs_52_sel_we,
                   vitAcs_52_pmOut, vitAcs_52_pmOut_or, vitAcs_52_pmOut_ff, vitAcs_52_pmOut_we,
                   vitAcs_52_sb, vitAcs_52_sb_ir, vitAcs_52_sb_fe, vitAcs_52_sb_re, 
                   vitAcs_52_pmIn0, vitAcs_52_pmIn0_ir, vitAcs_52_pmIn0_fe, vitAcs_52_pmIn0_re, 
                   vitAcs_52_pmIn1, vitAcs_52_pmIn1_ir, vitAcs_52_pmIn1_fe, vitAcs_52_pmIn1_re, 
                   vitAcs_52_run1, 
                   regBus, regWe, regRe, vitAcs_52_regWe, vitAcs_52_regRe, clk, clk2, reset);


//==============================================================================
