//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_44_sb_w            = 8;
  parameter vitAcs_44_pmIn0_w         = 9;
  parameter vitAcs_44_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_44_sel_w           = 1;
  parameter vitAcs_44_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_44_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_44_i0              = 1;
  parameter vitAcs_44_i1              = 0;
  parameter vitAcs_44_pbrv            = 412;
  parameter vitAcs_44_ws              = 4;
  parameter vitAcs_44_wp              = 9;

  // Iregs
  parameter vitAcs_44_pmBuf_w         = 9;
  parameter vitAcs_44_pmBuf_n         = 1;
  parameter vitAcs_44_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_44.sb_w            = vitAcs_44_sb_w;
  defparam vitAcs_44.pmIn0_w         = vitAcs_44_pmIn0_w;
  defparam vitAcs_44.pmIn1_w         = vitAcs_44_pmIn1_w;
  defparam vitAcs_44.sel_w           = vitAcs_44_sel_w;
  defparam vitAcs_44.pmOut_w         = vitAcs_44_pmOut_w;
  defparam vitAcs_44.run1_w          = vitAcs_44_run1_w;
  defparam vitAcs_44.i0              = vitAcs_44_i0;
  defparam vitAcs_44.i1              = vitAcs_44_i1;
  defparam vitAcs_44.pbrv            = vitAcs_44_pbrv;
  defparam vitAcs_44.ws              = vitAcs_44_ws;
  defparam vitAcs_44.wp              = vitAcs_44_wp;
  defparam vitAcs_44.pmBuf_w         = vitAcs_44_pmBuf_w;
  defparam vitAcs_44.pmBuf_n         = vitAcs_44_pmBuf_n;
  defparam vitAcs_44.pmBuf_m         = vitAcs_44_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_44_sel_w-1:0]  vitAcs_44_sel;
  wire                                      vitAcs_44_sel_or;
  wire                                      vitAcs_44_sel_ff;
  wire                                      vitAcs_44_sel_we;

  wire             [vitAcs_44_pmOut_w-1:0]  vitAcs_44_pmOut;
  wire                                      vitAcs_44_pmOut_or;
  wire                                      vitAcs_44_pmOut_ff;
  wire                                      vitAcs_44_pmOut_we;

  wire                [vitAcs_44_sb_w-1:0]  vitAcs_44_sb;
  wire                                      vitAcs_44_sb_ir;
  wire                                      vitAcs_44_sb_fe;
  wire                                      vitAcs_44_sb_re;

  wire             [vitAcs_44_pmIn0_w-1:0]  vitAcs_44_pmIn0;
  wire                                      vitAcs_44_pmIn0_ir;
  wire                                      vitAcs_44_pmIn0_fe;
  wire                                      vitAcs_44_pmIn0_re;

  wire             [vitAcs_44_pmIn1_w-1:0]  vitAcs_44_pmIn1;
  wire                                      vitAcs_44_pmIn1_ir;
  wire                                      vitAcs_44_pmIn1_fe;
  wire                                      vitAcs_44_pmIn1_re;

  wire              [vitAcs_44_run1_w-1:0]  vitAcs_44_run1;

  wire                                      vitAcs_44_regWe;
  wire                                      vitAcs_44_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_44(vitAcs_44_sel, vitAcs_44_sel_or, vitAcs_44_sel_ff, vitAcs_44_sel_we,
                   vitAcs_44_pmOut, vitAcs_44_pmOut_or, vitAcs_44_pmOut_ff, vitAcs_44_pmOut_we,
                   vitAcs_44_sb, vitAcs_44_sb_ir, vitAcs_44_sb_fe, vitAcs_44_sb_re, 
                   vitAcs_44_pmIn0, vitAcs_44_pmIn0_ir, vitAcs_44_pmIn0_fe, vitAcs_44_pmIn0_re, 
                   vitAcs_44_pmIn1, vitAcs_44_pmIn1_ir, vitAcs_44_pmIn1_fe, vitAcs_44_pmIn1_re, 
                   vitAcs_44_run1, 
                   regBus, regWe, regRe, vitAcs_44_regWe, vitAcs_44_regRe, clk, clk2, reset);


//==============================================================================
