//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_40_sb_w            = 8;
  parameter vitAcs_40_pmIn0_w         = 9;
  parameter vitAcs_40_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_40_sel_w           = 1;
  parameter vitAcs_40_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_40_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_40_i0              = 0;
  parameter vitAcs_40_i1              = 1;
  parameter vitAcs_40_pbrv            = 412;
  parameter vitAcs_40_ws              = 4;
  parameter vitAcs_40_wp              = 9;

  // Iregs
  parameter vitAcs_40_pmBuf_w         = 9;
  parameter vitAcs_40_pmBuf_n         = 1;
  parameter vitAcs_40_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_40.sb_w            = vitAcs_40_sb_w;
  defparam vitAcs_40.pmIn0_w         = vitAcs_40_pmIn0_w;
  defparam vitAcs_40.pmIn1_w         = vitAcs_40_pmIn1_w;
  defparam vitAcs_40.sel_w           = vitAcs_40_sel_w;
  defparam vitAcs_40.pmOut_w         = vitAcs_40_pmOut_w;
  defparam vitAcs_40.run1_w          = vitAcs_40_run1_w;
  defparam vitAcs_40.i0              = vitAcs_40_i0;
  defparam vitAcs_40.i1              = vitAcs_40_i1;
  defparam vitAcs_40.pbrv            = vitAcs_40_pbrv;
  defparam vitAcs_40.ws              = vitAcs_40_ws;
  defparam vitAcs_40.wp              = vitAcs_40_wp;
  defparam vitAcs_40.pmBuf_w         = vitAcs_40_pmBuf_w;
  defparam vitAcs_40.pmBuf_n         = vitAcs_40_pmBuf_n;
  defparam vitAcs_40.pmBuf_m         = vitAcs_40_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_40_sel_w-1:0]  vitAcs_40_sel;
  wire                                      vitAcs_40_sel_or;
  wire                                      vitAcs_40_sel_ff;
  wire                                      vitAcs_40_sel_we;

  wire             [vitAcs_40_pmOut_w-1:0]  vitAcs_40_pmOut;
  wire                                      vitAcs_40_pmOut_or;
  wire                                      vitAcs_40_pmOut_ff;
  wire                                      vitAcs_40_pmOut_we;

  wire                [vitAcs_40_sb_w-1:0]  vitAcs_40_sb;
  wire                                      vitAcs_40_sb_ir;
  wire                                      vitAcs_40_sb_fe;
  wire                                      vitAcs_40_sb_re;

  wire             [vitAcs_40_pmIn0_w-1:0]  vitAcs_40_pmIn0;
  wire                                      vitAcs_40_pmIn0_ir;
  wire                                      vitAcs_40_pmIn0_fe;
  wire                                      vitAcs_40_pmIn0_re;

  wire             [vitAcs_40_pmIn1_w-1:0]  vitAcs_40_pmIn1;
  wire                                      vitAcs_40_pmIn1_ir;
  wire                                      vitAcs_40_pmIn1_fe;
  wire                                      vitAcs_40_pmIn1_re;

  wire              [vitAcs_40_run1_w-1:0]  vitAcs_40_run1;

  wire                                      vitAcs_40_regWe;
  wire                                      vitAcs_40_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_40(vitAcs_40_sel, vitAcs_40_sel_or, vitAcs_40_sel_ff, vitAcs_40_sel_we,
                   vitAcs_40_pmOut, vitAcs_40_pmOut_or, vitAcs_40_pmOut_ff, vitAcs_40_pmOut_we,
                   vitAcs_40_sb, vitAcs_40_sb_ir, vitAcs_40_sb_fe, vitAcs_40_sb_re, 
                   vitAcs_40_pmIn0, vitAcs_40_pmIn0_ir, vitAcs_40_pmIn0_fe, vitAcs_40_pmIn0_re, 
                   vitAcs_40_pmIn1, vitAcs_40_pmIn1_ir, vitAcs_40_pmIn1_fe, vitAcs_40_pmIn1_re, 
                   vitAcs_40_run1, 
                   regBus, regWe, regRe, vitAcs_40_regWe, vitAcs_40_regRe, clk, clk2, reset);


//==============================================================================
