//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_35_sb_w            = 8;
  parameter vitAcs_35_pmIn0_w         = 9;
  parameter vitAcs_35_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_35_sel_w           = 1;
  parameter vitAcs_35_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_35_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_35_i0              = 0;
  parameter vitAcs_35_i1              = 0;
  parameter vitAcs_35_pbrv            = 412;
  parameter vitAcs_35_ws              = 4;
  parameter vitAcs_35_wp              = 9;

  // Iregs
  parameter vitAcs_35_pmBuf_w         = 9;
  parameter vitAcs_35_pmBuf_n         = 1;
  parameter vitAcs_35_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_35.sb_w            = vitAcs_35_sb_w;
  defparam vitAcs_35.pmIn0_w         = vitAcs_35_pmIn0_w;
  defparam vitAcs_35.pmIn1_w         = vitAcs_35_pmIn1_w;
  defparam vitAcs_35.sel_w           = vitAcs_35_sel_w;
  defparam vitAcs_35.pmOut_w         = vitAcs_35_pmOut_w;
  defparam vitAcs_35.run1_w          = vitAcs_35_run1_w;
  defparam vitAcs_35.i0              = vitAcs_35_i0;
  defparam vitAcs_35.i1              = vitAcs_35_i1;
  defparam vitAcs_35.pbrv            = vitAcs_35_pbrv;
  defparam vitAcs_35.ws              = vitAcs_35_ws;
  defparam vitAcs_35.wp              = vitAcs_35_wp;
  defparam vitAcs_35.pmBuf_w         = vitAcs_35_pmBuf_w;
  defparam vitAcs_35.pmBuf_n         = vitAcs_35_pmBuf_n;
  defparam vitAcs_35.pmBuf_m         = vitAcs_35_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_35_sel_w-1:0]  vitAcs_35_sel;
  wire                                      vitAcs_35_sel_or;
  wire                                      vitAcs_35_sel_ff;
  wire                                      vitAcs_35_sel_we;

  wire             [vitAcs_35_pmOut_w-1:0]  vitAcs_35_pmOut;
  wire                                      vitAcs_35_pmOut_or;
  wire                                      vitAcs_35_pmOut_ff;
  wire                                      vitAcs_35_pmOut_we;

  wire                [vitAcs_35_sb_w-1:0]  vitAcs_35_sb;
  wire                                      vitAcs_35_sb_ir;
  wire                                      vitAcs_35_sb_fe;
  wire                                      vitAcs_35_sb_re;

  wire             [vitAcs_35_pmIn0_w-1:0]  vitAcs_35_pmIn0;
  wire                                      vitAcs_35_pmIn0_ir;
  wire                                      vitAcs_35_pmIn0_fe;
  wire                                      vitAcs_35_pmIn0_re;

  wire             [vitAcs_35_pmIn1_w-1:0]  vitAcs_35_pmIn1;
  wire                                      vitAcs_35_pmIn1_ir;
  wire                                      vitAcs_35_pmIn1_fe;
  wire                                      vitAcs_35_pmIn1_re;

  wire              [vitAcs_35_run1_w-1:0]  vitAcs_35_run1;

  wire                                      vitAcs_35_regWe;
  wire                                      vitAcs_35_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_35(vitAcs_35_sel, vitAcs_35_sel_or, vitAcs_35_sel_ff, vitAcs_35_sel_we,
                   vitAcs_35_pmOut, vitAcs_35_pmOut_or, vitAcs_35_pmOut_ff, vitAcs_35_pmOut_we,
                   vitAcs_35_sb, vitAcs_35_sb_ir, vitAcs_35_sb_fe, vitAcs_35_sb_re, 
                   vitAcs_35_pmIn0, vitAcs_35_pmIn0_ir, vitAcs_35_pmIn0_fe, vitAcs_35_pmIn0_re, 
                   vitAcs_35_pmIn1, vitAcs_35_pmIn1_ir, vitAcs_35_pmIn1_fe, vitAcs_35_pmIn1_re, 
                   vitAcs_35_run1, 
                   regBus, regWe, regRe, vitAcs_35_regWe, vitAcs_35_regRe, clk, clk2, reset);


//==============================================================================
