//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_33_sb_w            = 8;
  parameter vitAcs_33_pmIn0_w         = 9;
  parameter vitAcs_33_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_33_sel_w           = 1;
  parameter vitAcs_33_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_33_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_33_i0              = 0;
  parameter vitAcs_33_i1              = 1;
  parameter vitAcs_33_pbrv            = 412;
  parameter vitAcs_33_ws              = 4;
  parameter vitAcs_33_wp              = 9;

  // Iregs
  parameter vitAcs_33_pmBuf_w         = 9;
  parameter vitAcs_33_pmBuf_n         = 1;
  parameter vitAcs_33_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_33.sb_w            = vitAcs_33_sb_w;
  defparam vitAcs_33.pmIn0_w         = vitAcs_33_pmIn0_w;
  defparam vitAcs_33.pmIn1_w         = vitAcs_33_pmIn1_w;
  defparam vitAcs_33.sel_w           = vitAcs_33_sel_w;
  defparam vitAcs_33.pmOut_w         = vitAcs_33_pmOut_w;
  defparam vitAcs_33.run1_w          = vitAcs_33_run1_w;
  defparam vitAcs_33.i0              = vitAcs_33_i0;
  defparam vitAcs_33.i1              = vitAcs_33_i1;
  defparam vitAcs_33.pbrv            = vitAcs_33_pbrv;
  defparam vitAcs_33.ws              = vitAcs_33_ws;
  defparam vitAcs_33.wp              = vitAcs_33_wp;
  defparam vitAcs_33.pmBuf_w         = vitAcs_33_pmBuf_w;
  defparam vitAcs_33.pmBuf_n         = vitAcs_33_pmBuf_n;
  defparam vitAcs_33.pmBuf_m         = vitAcs_33_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_33_sel_w-1:0]  vitAcs_33_sel;
  wire                                      vitAcs_33_sel_or;
  wire                                      vitAcs_33_sel_ff;
  wire                                      vitAcs_33_sel_we;

  wire             [vitAcs_33_pmOut_w-1:0]  vitAcs_33_pmOut;
  wire                                      vitAcs_33_pmOut_or;
  wire                                      vitAcs_33_pmOut_ff;
  wire                                      vitAcs_33_pmOut_we;

  wire                [vitAcs_33_sb_w-1:0]  vitAcs_33_sb;
  wire                                      vitAcs_33_sb_ir;
  wire                                      vitAcs_33_sb_fe;
  wire                                      vitAcs_33_sb_re;

  wire             [vitAcs_33_pmIn0_w-1:0]  vitAcs_33_pmIn0;
  wire                                      vitAcs_33_pmIn0_ir;
  wire                                      vitAcs_33_pmIn0_fe;
  wire                                      vitAcs_33_pmIn0_re;

  wire             [vitAcs_33_pmIn1_w-1:0]  vitAcs_33_pmIn1;
  wire                                      vitAcs_33_pmIn1_ir;
  wire                                      vitAcs_33_pmIn1_fe;
  wire                                      vitAcs_33_pmIn1_re;

  wire              [vitAcs_33_run1_w-1:0]  vitAcs_33_run1;

  wire                                      vitAcs_33_regWe;
  wire                                      vitAcs_33_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_33(vitAcs_33_sel, vitAcs_33_sel_or, vitAcs_33_sel_ff, vitAcs_33_sel_we,
                   vitAcs_33_pmOut, vitAcs_33_pmOut_or, vitAcs_33_pmOut_ff, vitAcs_33_pmOut_we,
                   vitAcs_33_sb, vitAcs_33_sb_ir, vitAcs_33_sb_fe, vitAcs_33_sb_re, 
                   vitAcs_33_pmIn0, vitAcs_33_pmIn0_ir, vitAcs_33_pmIn0_fe, vitAcs_33_pmIn0_re, 
                   vitAcs_33_pmIn1, vitAcs_33_pmIn1_ir, vitAcs_33_pmIn1_fe, vitAcs_33_pmIn1_re, 
                   vitAcs_33_run1, 
                   regBus, regWe, regRe, vitAcs_33_regWe, vitAcs_33_regRe, clk, clk2, reset);


//==============================================================================
