//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_29_sb_w            = 8;
  parameter vitAcs_29_pmIn0_w         = 9;
  parameter vitAcs_29_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_29_sel_w           = 1;
  parameter vitAcs_29_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_29_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_29_i0              = 1;
  parameter vitAcs_29_i1              = 1;
  parameter vitAcs_29_pbrv            = 412;
  parameter vitAcs_29_ws              = 4;
  parameter vitAcs_29_wp              = 9;

  // Iregs
  parameter vitAcs_29_pmBuf_w         = 9;
  parameter vitAcs_29_pmBuf_n         = 1;
  parameter vitAcs_29_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_29.sb_w            = vitAcs_29_sb_w;
  defparam vitAcs_29.pmIn0_w         = vitAcs_29_pmIn0_w;
  defparam vitAcs_29.pmIn1_w         = vitAcs_29_pmIn1_w;
  defparam vitAcs_29.sel_w           = vitAcs_29_sel_w;
  defparam vitAcs_29.pmOut_w         = vitAcs_29_pmOut_w;
  defparam vitAcs_29.run1_w          = vitAcs_29_run1_w;
  defparam vitAcs_29.i0              = vitAcs_29_i0;
  defparam vitAcs_29.i1              = vitAcs_29_i1;
  defparam vitAcs_29.pbrv            = vitAcs_29_pbrv;
  defparam vitAcs_29.ws              = vitAcs_29_ws;
  defparam vitAcs_29.wp              = vitAcs_29_wp;
  defparam vitAcs_29.pmBuf_w         = vitAcs_29_pmBuf_w;
  defparam vitAcs_29.pmBuf_n         = vitAcs_29_pmBuf_n;
  defparam vitAcs_29.pmBuf_m         = vitAcs_29_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_29_sel_w-1:0]  vitAcs_29_sel;
  wire                                      vitAcs_29_sel_or;
  wire                                      vitAcs_29_sel_ff;
  wire                                      vitAcs_29_sel_we;

  wire             [vitAcs_29_pmOut_w-1:0]  vitAcs_29_pmOut;
  wire                                      vitAcs_29_pmOut_or;
  wire                                      vitAcs_29_pmOut_ff;
  wire                                      vitAcs_29_pmOut_we;

  wire                [vitAcs_29_sb_w-1:0]  vitAcs_29_sb;
  wire                                      vitAcs_29_sb_ir;
  wire                                      vitAcs_29_sb_fe;
  wire                                      vitAcs_29_sb_re;

  wire             [vitAcs_29_pmIn0_w-1:0]  vitAcs_29_pmIn0;
  wire                                      vitAcs_29_pmIn0_ir;
  wire                                      vitAcs_29_pmIn0_fe;
  wire                                      vitAcs_29_pmIn0_re;

  wire             [vitAcs_29_pmIn1_w-1:0]  vitAcs_29_pmIn1;
  wire                                      vitAcs_29_pmIn1_ir;
  wire                                      vitAcs_29_pmIn1_fe;
  wire                                      vitAcs_29_pmIn1_re;

  wire              [vitAcs_29_run1_w-1:0]  vitAcs_29_run1;

  wire                                      vitAcs_29_regWe;
  wire                                      vitAcs_29_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_29(vitAcs_29_sel, vitAcs_29_sel_or, vitAcs_29_sel_ff, vitAcs_29_sel_we,
                   vitAcs_29_pmOut, vitAcs_29_pmOut_or, vitAcs_29_pmOut_ff, vitAcs_29_pmOut_we,
                   vitAcs_29_sb, vitAcs_29_sb_ir, vitAcs_29_sb_fe, vitAcs_29_sb_re, 
                   vitAcs_29_pmIn0, vitAcs_29_pmIn0_ir, vitAcs_29_pmIn0_fe, vitAcs_29_pmIn0_re, 
                   vitAcs_29_pmIn1, vitAcs_29_pmIn1_ir, vitAcs_29_pmIn1_fe, vitAcs_29_pmIn1_re, 
                   vitAcs_29_run1, 
                   regBus, regWe, regRe, vitAcs_29_regWe, vitAcs_29_regRe, clk, clk2, reset);


//==============================================================================
