//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_28_sb_w            = 8;
  parameter vitAcs_28_pmIn0_w         = 9;
  parameter vitAcs_28_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_28_sel_w           = 1;
  parameter vitAcs_28_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_28_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_28_i0              = 0;
  parameter vitAcs_28_i1              = 0;
  parameter vitAcs_28_pbrv            = 412;
  parameter vitAcs_28_ws              = 4;
  parameter vitAcs_28_wp              = 9;

  // Iregs
  parameter vitAcs_28_pmBuf_w         = 9;
  parameter vitAcs_28_pmBuf_n         = 1;
  parameter vitAcs_28_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_28.sb_w            = vitAcs_28_sb_w;
  defparam vitAcs_28.pmIn0_w         = vitAcs_28_pmIn0_w;
  defparam vitAcs_28.pmIn1_w         = vitAcs_28_pmIn1_w;
  defparam vitAcs_28.sel_w           = vitAcs_28_sel_w;
  defparam vitAcs_28.pmOut_w         = vitAcs_28_pmOut_w;
  defparam vitAcs_28.run1_w          = vitAcs_28_run1_w;
  defparam vitAcs_28.i0              = vitAcs_28_i0;
  defparam vitAcs_28.i1              = vitAcs_28_i1;
  defparam vitAcs_28.pbrv            = vitAcs_28_pbrv;
  defparam vitAcs_28.ws              = vitAcs_28_ws;
  defparam vitAcs_28.wp              = vitAcs_28_wp;
  defparam vitAcs_28.pmBuf_w         = vitAcs_28_pmBuf_w;
  defparam vitAcs_28.pmBuf_n         = vitAcs_28_pmBuf_n;
  defparam vitAcs_28.pmBuf_m         = vitAcs_28_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_28_sel_w-1:0]  vitAcs_28_sel;
  wire                                      vitAcs_28_sel_or;
  wire                                      vitAcs_28_sel_ff;
  wire                                      vitAcs_28_sel_we;

  wire             [vitAcs_28_pmOut_w-1:0]  vitAcs_28_pmOut;
  wire                                      vitAcs_28_pmOut_or;
  wire                                      vitAcs_28_pmOut_ff;
  wire                                      vitAcs_28_pmOut_we;

  wire                [vitAcs_28_sb_w-1:0]  vitAcs_28_sb;
  wire                                      vitAcs_28_sb_ir;
  wire                                      vitAcs_28_sb_fe;
  wire                                      vitAcs_28_sb_re;

  wire             [vitAcs_28_pmIn0_w-1:0]  vitAcs_28_pmIn0;
  wire                                      vitAcs_28_pmIn0_ir;
  wire                                      vitAcs_28_pmIn0_fe;
  wire                                      vitAcs_28_pmIn0_re;

  wire             [vitAcs_28_pmIn1_w-1:0]  vitAcs_28_pmIn1;
  wire                                      vitAcs_28_pmIn1_ir;
  wire                                      vitAcs_28_pmIn1_fe;
  wire                                      vitAcs_28_pmIn1_re;

  wire              [vitAcs_28_run1_w-1:0]  vitAcs_28_run1;

  wire                                      vitAcs_28_regWe;
  wire                                      vitAcs_28_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_28(vitAcs_28_sel, vitAcs_28_sel_or, vitAcs_28_sel_ff, vitAcs_28_sel_we,
                   vitAcs_28_pmOut, vitAcs_28_pmOut_or, vitAcs_28_pmOut_ff, vitAcs_28_pmOut_we,
                   vitAcs_28_sb, vitAcs_28_sb_ir, vitAcs_28_sb_fe, vitAcs_28_sb_re, 
                   vitAcs_28_pmIn0, vitAcs_28_pmIn0_ir, vitAcs_28_pmIn0_fe, vitAcs_28_pmIn0_re, 
                   vitAcs_28_pmIn1, vitAcs_28_pmIn1_ir, vitAcs_28_pmIn1_fe, vitAcs_28_pmIn1_re, 
                   vitAcs_28_run1, 
                   regBus, regWe, regRe, vitAcs_28_regWe, vitAcs_28_regRe, clk, clk2, reset);


//==============================================================================
