//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_26_sb_w            = 8;
  parameter vitAcs_26_pmIn0_w         = 9;
  parameter vitAcs_26_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_26_sel_w           = 1;
  parameter vitAcs_26_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_26_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_26_i0              = 1;
  parameter vitAcs_26_i1              = 0;
  parameter vitAcs_26_pbrv            = 412;
  parameter vitAcs_26_ws              = 4;
  parameter vitAcs_26_wp              = 9;

  // Iregs
  parameter vitAcs_26_pmBuf_w         = 9;
  parameter vitAcs_26_pmBuf_n         = 1;
  parameter vitAcs_26_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_26.sb_w            = vitAcs_26_sb_w;
  defparam vitAcs_26.pmIn0_w         = vitAcs_26_pmIn0_w;
  defparam vitAcs_26.pmIn1_w         = vitAcs_26_pmIn1_w;
  defparam vitAcs_26.sel_w           = vitAcs_26_sel_w;
  defparam vitAcs_26.pmOut_w         = vitAcs_26_pmOut_w;
  defparam vitAcs_26.run1_w          = vitAcs_26_run1_w;
  defparam vitAcs_26.i0              = vitAcs_26_i0;
  defparam vitAcs_26.i1              = vitAcs_26_i1;
  defparam vitAcs_26.pbrv            = vitAcs_26_pbrv;
  defparam vitAcs_26.ws              = vitAcs_26_ws;
  defparam vitAcs_26.wp              = vitAcs_26_wp;
  defparam vitAcs_26.pmBuf_w         = vitAcs_26_pmBuf_w;
  defparam vitAcs_26.pmBuf_n         = vitAcs_26_pmBuf_n;
  defparam vitAcs_26.pmBuf_m         = vitAcs_26_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_26_sel_w-1:0]  vitAcs_26_sel;
  wire                                      vitAcs_26_sel_or;
  wire                                      vitAcs_26_sel_ff;
  wire                                      vitAcs_26_sel_we;

  wire             [vitAcs_26_pmOut_w-1:0]  vitAcs_26_pmOut;
  wire                                      vitAcs_26_pmOut_or;
  wire                                      vitAcs_26_pmOut_ff;
  wire                                      vitAcs_26_pmOut_we;

  wire                [vitAcs_26_sb_w-1:0]  vitAcs_26_sb;
  wire                                      vitAcs_26_sb_ir;
  wire                                      vitAcs_26_sb_fe;
  wire                                      vitAcs_26_sb_re;

  wire             [vitAcs_26_pmIn0_w-1:0]  vitAcs_26_pmIn0;
  wire                                      vitAcs_26_pmIn0_ir;
  wire                                      vitAcs_26_pmIn0_fe;
  wire                                      vitAcs_26_pmIn0_re;

  wire             [vitAcs_26_pmIn1_w-1:0]  vitAcs_26_pmIn1;
  wire                                      vitAcs_26_pmIn1_ir;
  wire                                      vitAcs_26_pmIn1_fe;
  wire                                      vitAcs_26_pmIn1_re;

  wire              [vitAcs_26_run1_w-1:0]  vitAcs_26_run1;

  wire                                      vitAcs_26_regWe;
  wire                                      vitAcs_26_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_26(vitAcs_26_sel, vitAcs_26_sel_or, vitAcs_26_sel_ff, vitAcs_26_sel_we,
                   vitAcs_26_pmOut, vitAcs_26_pmOut_or, vitAcs_26_pmOut_ff, vitAcs_26_pmOut_we,
                   vitAcs_26_sb, vitAcs_26_sb_ir, vitAcs_26_sb_fe, vitAcs_26_sb_re, 
                   vitAcs_26_pmIn0, vitAcs_26_pmIn0_ir, vitAcs_26_pmIn0_fe, vitAcs_26_pmIn0_re, 
                   vitAcs_26_pmIn1, vitAcs_26_pmIn1_ir, vitAcs_26_pmIn1_fe, vitAcs_26_pmIn1_re, 
                   vitAcs_26_run1, 
                   regBus, regWe, regRe, vitAcs_26_regWe, vitAcs_26_regRe, clk, clk2, reset);


//==============================================================================
