//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_24_sb_w            = 8;
  parameter vitAcs_24_pmIn0_w         = 9;
  parameter vitAcs_24_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_24_sel_w           = 1;
  parameter vitAcs_24_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_24_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_24_i0              = 1;
  parameter vitAcs_24_i1              = 1;
  parameter vitAcs_24_pbrv            = 412;
  parameter vitAcs_24_ws              = 4;
  parameter vitAcs_24_wp              = 9;

  // Iregs
  parameter vitAcs_24_pmBuf_w         = 9;
  parameter vitAcs_24_pmBuf_n         = 1;
  parameter vitAcs_24_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_24.sb_w            = vitAcs_24_sb_w;
  defparam vitAcs_24.pmIn0_w         = vitAcs_24_pmIn0_w;
  defparam vitAcs_24.pmIn1_w         = vitAcs_24_pmIn1_w;
  defparam vitAcs_24.sel_w           = vitAcs_24_sel_w;
  defparam vitAcs_24.pmOut_w         = vitAcs_24_pmOut_w;
  defparam vitAcs_24.run1_w          = vitAcs_24_run1_w;
  defparam vitAcs_24.i0              = vitAcs_24_i0;
  defparam vitAcs_24.i1              = vitAcs_24_i1;
  defparam vitAcs_24.pbrv            = vitAcs_24_pbrv;
  defparam vitAcs_24.ws              = vitAcs_24_ws;
  defparam vitAcs_24.wp              = vitAcs_24_wp;
  defparam vitAcs_24.pmBuf_w         = vitAcs_24_pmBuf_w;
  defparam vitAcs_24.pmBuf_n         = vitAcs_24_pmBuf_n;
  defparam vitAcs_24.pmBuf_m         = vitAcs_24_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_24_sel_w-1:0]  vitAcs_24_sel;
  wire                                      vitAcs_24_sel_or;
  wire                                      vitAcs_24_sel_ff;
  wire                                      vitAcs_24_sel_we;

  wire             [vitAcs_24_pmOut_w-1:0]  vitAcs_24_pmOut;
  wire                                      vitAcs_24_pmOut_or;
  wire                                      vitAcs_24_pmOut_ff;
  wire                                      vitAcs_24_pmOut_we;

  wire                [vitAcs_24_sb_w-1:0]  vitAcs_24_sb;
  wire                                      vitAcs_24_sb_ir;
  wire                                      vitAcs_24_sb_fe;
  wire                                      vitAcs_24_sb_re;

  wire             [vitAcs_24_pmIn0_w-1:0]  vitAcs_24_pmIn0;
  wire                                      vitAcs_24_pmIn0_ir;
  wire                                      vitAcs_24_pmIn0_fe;
  wire                                      vitAcs_24_pmIn0_re;

  wire             [vitAcs_24_pmIn1_w-1:0]  vitAcs_24_pmIn1;
  wire                                      vitAcs_24_pmIn1_ir;
  wire                                      vitAcs_24_pmIn1_fe;
  wire                                      vitAcs_24_pmIn1_re;

  wire              [vitAcs_24_run1_w-1:0]  vitAcs_24_run1;

  wire                                      vitAcs_24_regWe;
  wire                                      vitAcs_24_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_24(vitAcs_24_sel, vitAcs_24_sel_or, vitAcs_24_sel_ff, vitAcs_24_sel_we,
                   vitAcs_24_pmOut, vitAcs_24_pmOut_or, vitAcs_24_pmOut_ff, vitAcs_24_pmOut_we,
                   vitAcs_24_sb, vitAcs_24_sb_ir, vitAcs_24_sb_fe, vitAcs_24_sb_re, 
                   vitAcs_24_pmIn0, vitAcs_24_pmIn0_ir, vitAcs_24_pmIn0_fe, vitAcs_24_pmIn0_re, 
                   vitAcs_24_pmIn1, vitAcs_24_pmIn1_ir, vitAcs_24_pmIn1_fe, vitAcs_24_pmIn1_re, 
                   vitAcs_24_run1, 
                   regBus, regWe, regRe, vitAcs_24_regWe, vitAcs_24_regRe, clk, clk2, reset);


//==============================================================================
