//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_23_sb_w            = 8;
  parameter vitAcs_23_pmIn0_w         = 9;
  parameter vitAcs_23_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_23_sel_w           = 1;
  parameter vitAcs_23_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_23_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_23_i0              = 0;
  parameter vitAcs_23_i1              = 1;
  parameter vitAcs_23_pbrv            = 412;
  parameter vitAcs_23_ws              = 4;
  parameter vitAcs_23_wp              = 9;

  // Iregs
  parameter vitAcs_23_pmBuf_w         = 9;
  parameter vitAcs_23_pmBuf_n         = 1;
  parameter vitAcs_23_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_23.sb_w            = vitAcs_23_sb_w;
  defparam vitAcs_23.pmIn0_w         = vitAcs_23_pmIn0_w;
  defparam vitAcs_23.pmIn1_w         = vitAcs_23_pmIn1_w;
  defparam vitAcs_23.sel_w           = vitAcs_23_sel_w;
  defparam vitAcs_23.pmOut_w         = vitAcs_23_pmOut_w;
  defparam vitAcs_23.run1_w          = vitAcs_23_run1_w;
  defparam vitAcs_23.i0              = vitAcs_23_i0;
  defparam vitAcs_23.i1              = vitAcs_23_i1;
  defparam vitAcs_23.pbrv            = vitAcs_23_pbrv;
  defparam vitAcs_23.ws              = vitAcs_23_ws;
  defparam vitAcs_23.wp              = vitAcs_23_wp;
  defparam vitAcs_23.pmBuf_w         = vitAcs_23_pmBuf_w;
  defparam vitAcs_23.pmBuf_n         = vitAcs_23_pmBuf_n;
  defparam vitAcs_23.pmBuf_m         = vitAcs_23_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_23_sel_w-1:0]  vitAcs_23_sel;
  wire                                      vitAcs_23_sel_or;
  wire                                      vitAcs_23_sel_ff;
  wire                                      vitAcs_23_sel_we;

  wire             [vitAcs_23_pmOut_w-1:0]  vitAcs_23_pmOut;
  wire                                      vitAcs_23_pmOut_or;
  wire                                      vitAcs_23_pmOut_ff;
  wire                                      vitAcs_23_pmOut_we;

  wire                [vitAcs_23_sb_w-1:0]  vitAcs_23_sb;
  wire                                      vitAcs_23_sb_ir;
  wire                                      vitAcs_23_sb_fe;
  wire                                      vitAcs_23_sb_re;

  wire             [vitAcs_23_pmIn0_w-1:0]  vitAcs_23_pmIn0;
  wire                                      vitAcs_23_pmIn0_ir;
  wire                                      vitAcs_23_pmIn0_fe;
  wire                                      vitAcs_23_pmIn0_re;

  wire             [vitAcs_23_pmIn1_w-1:0]  vitAcs_23_pmIn1;
  wire                                      vitAcs_23_pmIn1_ir;
  wire                                      vitAcs_23_pmIn1_fe;
  wire                                      vitAcs_23_pmIn1_re;

  wire              [vitAcs_23_run1_w-1:0]  vitAcs_23_run1;

  wire                                      vitAcs_23_regWe;
  wire                                      vitAcs_23_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_23(vitAcs_23_sel, vitAcs_23_sel_or, vitAcs_23_sel_ff, vitAcs_23_sel_we,
                   vitAcs_23_pmOut, vitAcs_23_pmOut_or, vitAcs_23_pmOut_ff, vitAcs_23_pmOut_we,
                   vitAcs_23_sb, vitAcs_23_sb_ir, vitAcs_23_sb_fe, vitAcs_23_sb_re, 
                   vitAcs_23_pmIn0, vitAcs_23_pmIn0_ir, vitAcs_23_pmIn0_fe, vitAcs_23_pmIn0_re, 
                   vitAcs_23_pmIn1, vitAcs_23_pmIn1_ir, vitAcs_23_pmIn1_fe, vitAcs_23_pmIn1_re, 
                   vitAcs_23_run1, 
                   regBus, regWe, regRe, vitAcs_23_regWe, vitAcs_23_regRe, clk, clk2, reset);


//==============================================================================
