//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_20_sb_w            = 8;
  parameter vitAcs_20_pmIn0_w         = 9;
  parameter vitAcs_20_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_20_sel_w           = 1;
  parameter vitAcs_20_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_20_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_20_i0              = 1;
  parameter vitAcs_20_i1              = 1;
  parameter vitAcs_20_pbrv            = 412;
  parameter vitAcs_20_ws              = 4;
  parameter vitAcs_20_wp              = 9;

  // Iregs
  parameter vitAcs_20_pmBuf_w         = 9;
  parameter vitAcs_20_pmBuf_n         = 1;
  parameter vitAcs_20_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_20.sb_w            = vitAcs_20_sb_w;
  defparam vitAcs_20.pmIn0_w         = vitAcs_20_pmIn0_w;
  defparam vitAcs_20.pmIn1_w         = vitAcs_20_pmIn1_w;
  defparam vitAcs_20.sel_w           = vitAcs_20_sel_w;
  defparam vitAcs_20.pmOut_w         = vitAcs_20_pmOut_w;
  defparam vitAcs_20.run1_w          = vitAcs_20_run1_w;
  defparam vitAcs_20.i0              = vitAcs_20_i0;
  defparam vitAcs_20.i1              = vitAcs_20_i1;
  defparam vitAcs_20.pbrv            = vitAcs_20_pbrv;
  defparam vitAcs_20.ws              = vitAcs_20_ws;
  defparam vitAcs_20.wp              = vitAcs_20_wp;
  defparam vitAcs_20.pmBuf_w         = vitAcs_20_pmBuf_w;
  defparam vitAcs_20.pmBuf_n         = vitAcs_20_pmBuf_n;
  defparam vitAcs_20.pmBuf_m         = vitAcs_20_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_20_sel_w-1:0]  vitAcs_20_sel;
  wire                                      vitAcs_20_sel_or;
  wire                                      vitAcs_20_sel_ff;
  wire                                      vitAcs_20_sel_we;

  wire             [vitAcs_20_pmOut_w-1:0]  vitAcs_20_pmOut;
  wire                                      vitAcs_20_pmOut_or;
  wire                                      vitAcs_20_pmOut_ff;
  wire                                      vitAcs_20_pmOut_we;

  wire                [vitAcs_20_sb_w-1:0]  vitAcs_20_sb;
  wire                                      vitAcs_20_sb_ir;
  wire                                      vitAcs_20_sb_fe;
  wire                                      vitAcs_20_sb_re;

  wire             [vitAcs_20_pmIn0_w-1:0]  vitAcs_20_pmIn0;
  wire                                      vitAcs_20_pmIn0_ir;
  wire                                      vitAcs_20_pmIn0_fe;
  wire                                      vitAcs_20_pmIn0_re;

  wire             [vitAcs_20_pmIn1_w-1:0]  vitAcs_20_pmIn1;
  wire                                      vitAcs_20_pmIn1_ir;
  wire                                      vitAcs_20_pmIn1_fe;
  wire                                      vitAcs_20_pmIn1_re;

  wire              [vitAcs_20_run1_w-1:0]  vitAcs_20_run1;

  wire                                      vitAcs_20_regWe;
  wire                                      vitAcs_20_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_20(vitAcs_20_sel, vitAcs_20_sel_or, vitAcs_20_sel_ff, vitAcs_20_sel_we,
                   vitAcs_20_pmOut, vitAcs_20_pmOut_or, vitAcs_20_pmOut_ff, vitAcs_20_pmOut_we,
                   vitAcs_20_sb, vitAcs_20_sb_ir, vitAcs_20_sb_fe, vitAcs_20_sb_re, 
                   vitAcs_20_pmIn0, vitAcs_20_pmIn0_ir, vitAcs_20_pmIn0_fe, vitAcs_20_pmIn0_re, 
                   vitAcs_20_pmIn1, vitAcs_20_pmIn1_ir, vitAcs_20_pmIn1_fe, vitAcs_20_pmIn1_re, 
                   vitAcs_20_run1, 
                   regBus, regWe, regRe, vitAcs_20_regWe, vitAcs_20_regRe, clk, clk2, reset);


//==============================================================================
