//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_14_sb_w            = 8;
  parameter vitAcs_14_pmIn0_w         = 9;
  parameter vitAcs_14_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_14_sel_w           = 1;
  parameter vitAcs_14_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_14_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_14_i0              = 0;
  parameter vitAcs_14_i1              = 1;
  parameter vitAcs_14_pbrv            = 412;
  parameter vitAcs_14_ws              = 4;
  parameter vitAcs_14_wp              = 9;

  // Iregs
  parameter vitAcs_14_pmBuf_w         = 9;
  parameter vitAcs_14_pmBuf_n         = 1;
  parameter vitAcs_14_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_14.sb_w            = vitAcs_14_sb_w;
  defparam vitAcs_14.pmIn0_w         = vitAcs_14_pmIn0_w;
  defparam vitAcs_14.pmIn1_w         = vitAcs_14_pmIn1_w;
  defparam vitAcs_14.sel_w           = vitAcs_14_sel_w;
  defparam vitAcs_14.pmOut_w         = vitAcs_14_pmOut_w;
  defparam vitAcs_14.run1_w          = vitAcs_14_run1_w;
  defparam vitAcs_14.i0              = vitAcs_14_i0;
  defparam vitAcs_14.i1              = vitAcs_14_i1;
  defparam vitAcs_14.pbrv            = vitAcs_14_pbrv;
  defparam vitAcs_14.ws              = vitAcs_14_ws;
  defparam vitAcs_14.wp              = vitAcs_14_wp;
  defparam vitAcs_14.pmBuf_w         = vitAcs_14_pmBuf_w;
  defparam vitAcs_14.pmBuf_n         = vitAcs_14_pmBuf_n;
  defparam vitAcs_14.pmBuf_m         = vitAcs_14_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_14_sel_w-1:0]  vitAcs_14_sel;
  wire                                      vitAcs_14_sel_or;
  wire                                      vitAcs_14_sel_ff;
  wire                                      vitAcs_14_sel_we;

  wire             [vitAcs_14_pmOut_w-1:0]  vitAcs_14_pmOut;
  wire                                      vitAcs_14_pmOut_or;
  wire                                      vitAcs_14_pmOut_ff;
  wire                                      vitAcs_14_pmOut_we;

  wire                [vitAcs_14_sb_w-1:0]  vitAcs_14_sb;
  wire                                      vitAcs_14_sb_ir;
  wire                                      vitAcs_14_sb_fe;
  wire                                      vitAcs_14_sb_re;

  wire             [vitAcs_14_pmIn0_w-1:0]  vitAcs_14_pmIn0;
  wire                                      vitAcs_14_pmIn0_ir;
  wire                                      vitAcs_14_pmIn0_fe;
  wire                                      vitAcs_14_pmIn0_re;

  wire             [vitAcs_14_pmIn1_w-1:0]  vitAcs_14_pmIn1;
  wire                                      vitAcs_14_pmIn1_ir;
  wire                                      vitAcs_14_pmIn1_fe;
  wire                                      vitAcs_14_pmIn1_re;

  wire              [vitAcs_14_run1_w-1:0]  vitAcs_14_run1;

  wire                                      vitAcs_14_regWe;
  wire                                      vitAcs_14_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_14(vitAcs_14_sel, vitAcs_14_sel_or, vitAcs_14_sel_ff, vitAcs_14_sel_we,
                   vitAcs_14_pmOut, vitAcs_14_pmOut_or, vitAcs_14_pmOut_ff, vitAcs_14_pmOut_we,
                   vitAcs_14_sb, vitAcs_14_sb_ir, vitAcs_14_sb_fe, vitAcs_14_sb_re, 
                   vitAcs_14_pmIn0, vitAcs_14_pmIn0_ir, vitAcs_14_pmIn0_fe, vitAcs_14_pmIn0_re, 
                   vitAcs_14_pmIn1, vitAcs_14_pmIn1_ir, vitAcs_14_pmIn1_fe, vitAcs_14_pmIn1_re, 
                   vitAcs_14_run1, 
                   regBus, regWe, regRe, vitAcs_14_regWe, vitAcs_14_regRe, clk, clk2, reset);


//==============================================================================
