//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_11_sb_w            = 8;
  parameter vitAcs_11_pmIn0_w         = 9;
  parameter vitAcs_11_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_11_sel_w           = 1;
  parameter vitAcs_11_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_11_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_11_i0              = 0;
  parameter vitAcs_11_i1              = 1;
  parameter vitAcs_11_pbrv            = 412;
  parameter vitAcs_11_ws              = 4;
  parameter vitAcs_11_wp              = 9;

  // Iregs
  parameter vitAcs_11_pmBuf_w         = 9;
  parameter vitAcs_11_pmBuf_n         = 1;
  parameter vitAcs_11_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_11.sb_w            = vitAcs_11_sb_w;
  defparam vitAcs_11.pmIn0_w         = vitAcs_11_pmIn0_w;
  defparam vitAcs_11.pmIn1_w         = vitAcs_11_pmIn1_w;
  defparam vitAcs_11.sel_w           = vitAcs_11_sel_w;
  defparam vitAcs_11.pmOut_w         = vitAcs_11_pmOut_w;
  defparam vitAcs_11.run1_w          = vitAcs_11_run1_w;
  defparam vitAcs_11.i0              = vitAcs_11_i0;
  defparam vitAcs_11.i1              = vitAcs_11_i1;
  defparam vitAcs_11.pbrv            = vitAcs_11_pbrv;
  defparam vitAcs_11.ws              = vitAcs_11_ws;
  defparam vitAcs_11.wp              = vitAcs_11_wp;
  defparam vitAcs_11.pmBuf_w         = vitAcs_11_pmBuf_w;
  defparam vitAcs_11.pmBuf_n         = vitAcs_11_pmBuf_n;
  defparam vitAcs_11.pmBuf_m         = vitAcs_11_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_11_sel_w-1:0]  vitAcs_11_sel;
  wire                                      vitAcs_11_sel_or;
  wire                                      vitAcs_11_sel_ff;
  wire                                      vitAcs_11_sel_we;

  wire             [vitAcs_11_pmOut_w-1:0]  vitAcs_11_pmOut;
  wire                                      vitAcs_11_pmOut_or;
  wire                                      vitAcs_11_pmOut_ff;
  wire                                      vitAcs_11_pmOut_we;

  wire                [vitAcs_11_sb_w-1:0]  vitAcs_11_sb;
  wire                                      vitAcs_11_sb_ir;
  wire                                      vitAcs_11_sb_fe;
  wire                                      vitAcs_11_sb_re;

  wire             [vitAcs_11_pmIn0_w-1:0]  vitAcs_11_pmIn0;
  wire                                      vitAcs_11_pmIn0_ir;
  wire                                      vitAcs_11_pmIn0_fe;
  wire                                      vitAcs_11_pmIn0_re;

  wire             [vitAcs_11_pmIn1_w-1:0]  vitAcs_11_pmIn1;
  wire                                      vitAcs_11_pmIn1_ir;
  wire                                      vitAcs_11_pmIn1_fe;
  wire                                      vitAcs_11_pmIn1_re;

  wire              [vitAcs_11_run1_w-1:0]  vitAcs_11_run1;

  wire                                      vitAcs_11_regWe;
  wire                                      vitAcs_11_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_11(vitAcs_11_sel, vitAcs_11_sel_or, vitAcs_11_sel_ff, vitAcs_11_sel_we,
                   vitAcs_11_pmOut, vitAcs_11_pmOut_or, vitAcs_11_pmOut_ff, vitAcs_11_pmOut_we,
                   vitAcs_11_sb, vitAcs_11_sb_ir, vitAcs_11_sb_fe, vitAcs_11_sb_re, 
                   vitAcs_11_pmIn0, vitAcs_11_pmIn0_ir, vitAcs_11_pmIn0_fe, vitAcs_11_pmIn0_re, 
                   vitAcs_11_pmIn1, vitAcs_11_pmIn1_ir, vitAcs_11_pmIn1_fe, vitAcs_11_pmIn1_re, 
                   vitAcs_11_run1, 
                   regBus, regWe, regRe, vitAcs_11_regWe, vitAcs_11_regRe, clk, clk2, reset);


//==============================================================================
