//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_07_sb_w            = 8;
  parameter vitAcs_07_pmIn0_w         = 9;
  parameter vitAcs_07_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_07_sel_w           = 1;
  parameter vitAcs_07_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_07_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_07_i0              = 0;
  parameter vitAcs_07_i1              = 1;
  parameter vitAcs_07_pbrv            = 412;
  parameter vitAcs_07_ws              = 4;
  parameter vitAcs_07_wp              = 9;

  // Iregs
  parameter vitAcs_07_pmBuf_w         = 9;
  parameter vitAcs_07_pmBuf_n         = 1;
  parameter vitAcs_07_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_07.sb_w            = vitAcs_07_sb_w;
  defparam vitAcs_07.pmIn0_w         = vitAcs_07_pmIn0_w;
  defparam vitAcs_07.pmIn1_w         = vitAcs_07_pmIn1_w;
  defparam vitAcs_07.sel_w           = vitAcs_07_sel_w;
  defparam vitAcs_07.pmOut_w         = vitAcs_07_pmOut_w;
  defparam vitAcs_07.run1_w          = vitAcs_07_run1_w;
  defparam vitAcs_07.i0              = vitAcs_07_i0;
  defparam vitAcs_07.i1              = vitAcs_07_i1;
  defparam vitAcs_07.pbrv            = vitAcs_07_pbrv;
  defparam vitAcs_07.ws              = vitAcs_07_ws;
  defparam vitAcs_07.wp              = vitAcs_07_wp;
  defparam vitAcs_07.pmBuf_w         = vitAcs_07_pmBuf_w;
  defparam vitAcs_07.pmBuf_n         = vitAcs_07_pmBuf_n;
  defparam vitAcs_07.pmBuf_m         = vitAcs_07_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_07_sel_w-1:0]  vitAcs_07_sel;
  wire                                      vitAcs_07_sel_or;
  wire                                      vitAcs_07_sel_ff;
  wire                                      vitAcs_07_sel_we;

  wire             [vitAcs_07_pmOut_w-1:0]  vitAcs_07_pmOut;
  wire                                      vitAcs_07_pmOut_or;
  wire                                      vitAcs_07_pmOut_ff;
  wire                                      vitAcs_07_pmOut_we;

  wire                [vitAcs_07_sb_w-1:0]  vitAcs_07_sb;
  wire                                      vitAcs_07_sb_ir;
  wire                                      vitAcs_07_sb_fe;
  wire                                      vitAcs_07_sb_re;

  wire             [vitAcs_07_pmIn0_w-1:0]  vitAcs_07_pmIn0;
  wire                                      vitAcs_07_pmIn0_ir;
  wire                                      vitAcs_07_pmIn0_fe;
  wire                                      vitAcs_07_pmIn0_re;

  wire             [vitAcs_07_pmIn1_w-1:0]  vitAcs_07_pmIn1;
  wire                                      vitAcs_07_pmIn1_ir;
  wire                                      vitAcs_07_pmIn1_fe;
  wire                                      vitAcs_07_pmIn1_re;

  wire              [vitAcs_07_run1_w-1:0]  vitAcs_07_run1;

  wire                                      vitAcs_07_regWe;
  wire                                      vitAcs_07_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_07(vitAcs_07_sel, vitAcs_07_sel_or, vitAcs_07_sel_ff, vitAcs_07_sel_we,
                   vitAcs_07_pmOut, vitAcs_07_pmOut_or, vitAcs_07_pmOut_ff, vitAcs_07_pmOut_we,
                   vitAcs_07_sb, vitAcs_07_sb_ir, vitAcs_07_sb_fe, vitAcs_07_sb_re, 
                   vitAcs_07_pmIn0, vitAcs_07_pmIn0_ir, vitAcs_07_pmIn0_fe, vitAcs_07_pmIn0_re, 
                   vitAcs_07_pmIn1, vitAcs_07_pmIn1_ir, vitAcs_07_pmIn1_fe, vitAcs_07_pmIn1_re, 
                   vitAcs_07_run1, 
                   regBus, regWe, regRe, vitAcs_07_regWe, vitAcs_07_regRe, clk, clk2, reset);


//==============================================================================
