//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_06_sb_w            = 8;
  parameter vitAcs_06_pmIn0_w         = 9;
  parameter vitAcs_06_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_06_sel_w           = 1;
  parameter vitAcs_06_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_06_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_06_i0              = 1;
  parameter vitAcs_06_i1              = 0;
  parameter vitAcs_06_pbrv            = 412;
  parameter vitAcs_06_ws              = 4;
  parameter vitAcs_06_wp              = 9;

  // Iregs
  parameter vitAcs_06_pmBuf_w         = 9;
  parameter vitAcs_06_pmBuf_n         = 1;
  parameter vitAcs_06_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_06.sb_w            = vitAcs_06_sb_w;
  defparam vitAcs_06.pmIn0_w         = vitAcs_06_pmIn0_w;
  defparam vitAcs_06.pmIn1_w         = vitAcs_06_pmIn1_w;
  defparam vitAcs_06.sel_w           = vitAcs_06_sel_w;
  defparam vitAcs_06.pmOut_w         = vitAcs_06_pmOut_w;
  defparam vitAcs_06.run1_w          = vitAcs_06_run1_w;
  defparam vitAcs_06.i0              = vitAcs_06_i0;
  defparam vitAcs_06.i1              = vitAcs_06_i1;
  defparam vitAcs_06.pbrv            = vitAcs_06_pbrv;
  defparam vitAcs_06.ws              = vitAcs_06_ws;
  defparam vitAcs_06.wp              = vitAcs_06_wp;
  defparam vitAcs_06.pmBuf_w         = vitAcs_06_pmBuf_w;
  defparam vitAcs_06.pmBuf_n         = vitAcs_06_pmBuf_n;
  defparam vitAcs_06.pmBuf_m         = vitAcs_06_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_06_sel_w-1:0]  vitAcs_06_sel;
  wire                                      vitAcs_06_sel_or;
  wire                                      vitAcs_06_sel_ff;
  wire                                      vitAcs_06_sel_we;

  wire             [vitAcs_06_pmOut_w-1:0]  vitAcs_06_pmOut;
  wire                                      vitAcs_06_pmOut_or;
  wire                                      vitAcs_06_pmOut_ff;
  wire                                      vitAcs_06_pmOut_we;

  wire                [vitAcs_06_sb_w-1:0]  vitAcs_06_sb;
  wire                                      vitAcs_06_sb_ir;
  wire                                      vitAcs_06_sb_fe;
  wire                                      vitAcs_06_sb_re;

  wire             [vitAcs_06_pmIn0_w-1:0]  vitAcs_06_pmIn0;
  wire                                      vitAcs_06_pmIn0_ir;
  wire                                      vitAcs_06_pmIn0_fe;
  wire                                      vitAcs_06_pmIn0_re;

  wire             [vitAcs_06_pmIn1_w-1:0]  vitAcs_06_pmIn1;
  wire                                      vitAcs_06_pmIn1_ir;
  wire                                      vitAcs_06_pmIn1_fe;
  wire                                      vitAcs_06_pmIn1_re;

  wire              [vitAcs_06_run1_w-1:0]  vitAcs_06_run1;

  wire                                      vitAcs_06_regWe;
  wire                                      vitAcs_06_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_06(vitAcs_06_sel, vitAcs_06_sel_or, vitAcs_06_sel_ff, vitAcs_06_sel_we,
                   vitAcs_06_pmOut, vitAcs_06_pmOut_or, vitAcs_06_pmOut_ff, vitAcs_06_pmOut_we,
                   vitAcs_06_sb, vitAcs_06_sb_ir, vitAcs_06_sb_fe, vitAcs_06_sb_re, 
                   vitAcs_06_pmIn0, vitAcs_06_pmIn0_ir, vitAcs_06_pmIn0_fe, vitAcs_06_pmIn0_re, 
                   vitAcs_06_pmIn1, vitAcs_06_pmIn1_ir, vitAcs_06_pmIn1_fe, vitAcs_06_pmIn1_re, 
                   vitAcs_06_run1, 
                   regBus, regWe, regRe, vitAcs_06_regWe, vitAcs_06_regRe, clk, clk2, reset);


//==============================================================================
