//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_03_sb_w            = 8;
  parameter vitAcs_03_pmIn0_w         = 9;
  parameter vitAcs_03_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_03_sel_w           = 1;
  parameter vitAcs_03_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_03_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_03_i0              = 1;
  parameter vitAcs_03_i1              = 0;
  parameter vitAcs_03_pbrv            = 412;
  parameter vitAcs_03_ws              = 4;
  parameter vitAcs_03_wp              = 9;

  // Iregs
  parameter vitAcs_03_pmBuf_w         = 9;
  parameter vitAcs_03_pmBuf_n         = 1;
  parameter vitAcs_03_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_03.sb_w            = vitAcs_03_sb_w;
  defparam vitAcs_03.pmIn0_w         = vitAcs_03_pmIn0_w;
  defparam vitAcs_03.pmIn1_w         = vitAcs_03_pmIn1_w;
  defparam vitAcs_03.sel_w           = vitAcs_03_sel_w;
  defparam vitAcs_03.pmOut_w         = vitAcs_03_pmOut_w;
  defparam vitAcs_03.run1_w          = vitAcs_03_run1_w;
  defparam vitAcs_03.i0              = vitAcs_03_i0;
  defparam vitAcs_03.i1              = vitAcs_03_i1;
  defparam vitAcs_03.pbrv            = vitAcs_03_pbrv;
  defparam vitAcs_03.ws              = vitAcs_03_ws;
  defparam vitAcs_03.wp              = vitAcs_03_wp;
  defparam vitAcs_03.pmBuf_w         = vitAcs_03_pmBuf_w;
  defparam vitAcs_03.pmBuf_n         = vitAcs_03_pmBuf_n;
  defparam vitAcs_03.pmBuf_m         = vitAcs_03_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_03_sel_w-1:0]  vitAcs_03_sel;
  wire                                      vitAcs_03_sel_or;
  wire                                      vitAcs_03_sel_ff;
  wire                                      vitAcs_03_sel_we;

  wire             [vitAcs_03_pmOut_w-1:0]  vitAcs_03_pmOut;
  wire                                      vitAcs_03_pmOut_or;
  wire                                      vitAcs_03_pmOut_ff;
  wire                                      vitAcs_03_pmOut_we;

  wire                [vitAcs_03_sb_w-1:0]  vitAcs_03_sb;
  wire                                      vitAcs_03_sb_ir;
  wire                                      vitAcs_03_sb_fe;
  wire                                      vitAcs_03_sb_re;

  wire             [vitAcs_03_pmIn0_w-1:0]  vitAcs_03_pmIn0;
  wire                                      vitAcs_03_pmIn0_ir;
  wire                                      vitAcs_03_pmIn0_fe;
  wire                                      vitAcs_03_pmIn0_re;

  wire             [vitAcs_03_pmIn1_w-1:0]  vitAcs_03_pmIn1;
  wire                                      vitAcs_03_pmIn1_ir;
  wire                                      vitAcs_03_pmIn1_fe;
  wire                                      vitAcs_03_pmIn1_re;

  wire              [vitAcs_03_run1_w-1:0]  vitAcs_03_run1;

  wire                                      vitAcs_03_regWe;
  wire                                      vitAcs_03_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_03(vitAcs_03_sel, vitAcs_03_sel_or, vitAcs_03_sel_ff, vitAcs_03_sel_we,
                   vitAcs_03_pmOut, vitAcs_03_pmOut_or, vitAcs_03_pmOut_ff, vitAcs_03_pmOut_we,
                   vitAcs_03_sb, vitAcs_03_sb_ir, vitAcs_03_sb_fe, vitAcs_03_sb_re, 
                   vitAcs_03_pmIn0, vitAcs_03_pmIn0_ir, vitAcs_03_pmIn0_fe, vitAcs_03_pmIn0_re, 
                   vitAcs_03_pmIn1, vitAcs_03_pmIn1_ir, vitAcs_03_pmIn1_fe, vitAcs_03_pmIn1_re, 
                   vitAcs_03_run1, 
                   regBus, regWe, regRe, vitAcs_03_regWe, vitAcs_03_regRe, clk, clk2, reset);


//==============================================================================
