//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter vitAcs_01_sb_w            = 8;
  parameter vitAcs_01_pmIn0_w         = 9;
  parameter vitAcs_01_pmIn1_w         = 9;

  // Outputs
  parameter vitAcs_01_sel_w           = 1;
  parameter vitAcs_01_pmOut_w         = 9;

  // Input control lines
  parameter vitAcs_01_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter vitAcs_01_i0              = 1;
  parameter vitAcs_01_i1              = 1;
  parameter vitAcs_01_pbrv            = 412;
  parameter vitAcs_01_ws              = 4;
  parameter vitAcs_01_wp              = 9;

  // Iregs
  parameter vitAcs_01_pmBuf_w         = 9;
  parameter vitAcs_01_pmBuf_n         = 1;
  parameter vitAcs_01_pmBuf_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam vitAcs_01.sb_w            = vitAcs_01_sb_w;
  defparam vitAcs_01.pmIn0_w         = vitAcs_01_pmIn0_w;
  defparam vitAcs_01.pmIn1_w         = vitAcs_01_pmIn1_w;
  defparam vitAcs_01.sel_w           = vitAcs_01_sel_w;
  defparam vitAcs_01.pmOut_w         = vitAcs_01_pmOut_w;
  defparam vitAcs_01.run1_w          = vitAcs_01_run1_w;
  defparam vitAcs_01.i0              = vitAcs_01_i0;
  defparam vitAcs_01.i1              = vitAcs_01_i1;
  defparam vitAcs_01.pbrv            = vitAcs_01_pbrv;
  defparam vitAcs_01.ws              = vitAcs_01_ws;
  defparam vitAcs_01.wp              = vitAcs_01_wp;
  defparam vitAcs_01.pmBuf_w         = vitAcs_01_pmBuf_w;
  defparam vitAcs_01.pmBuf_n         = vitAcs_01_pmBuf_n;
  defparam vitAcs_01.pmBuf_m         = vitAcs_01_pmBuf_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire               [vitAcs_01_sel_w-1:0]  vitAcs_01_sel;
  wire                                      vitAcs_01_sel_or;
  wire                                      vitAcs_01_sel_ff;
  wire                                      vitAcs_01_sel_we;

  wire             [vitAcs_01_pmOut_w-1:0]  vitAcs_01_pmOut;
  wire                                      vitAcs_01_pmOut_or;
  wire                                      vitAcs_01_pmOut_ff;
  wire                                      vitAcs_01_pmOut_we;

  wire                [vitAcs_01_sb_w-1:0]  vitAcs_01_sb;
  wire                                      vitAcs_01_sb_ir;
  wire                                      vitAcs_01_sb_fe;
  wire                                      vitAcs_01_sb_re;

  wire             [vitAcs_01_pmIn0_w-1:0]  vitAcs_01_pmIn0;
  wire                                      vitAcs_01_pmIn0_ir;
  wire                                      vitAcs_01_pmIn0_fe;
  wire                                      vitAcs_01_pmIn0_re;

  wire             [vitAcs_01_pmIn1_w-1:0]  vitAcs_01_pmIn1;
  wire                                      vitAcs_01_pmIn1_ir;
  wire                                      vitAcs_01_pmIn1_fe;
  wire                                      vitAcs_01_pmIn1_re;

  wire              [vitAcs_01_run1_w-1:0]  vitAcs_01_run1;

  wire                                      vitAcs_01_regWe;
  wire                                      vitAcs_01_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  vitAcs vitAcs_01(vitAcs_01_sel, vitAcs_01_sel_or, vitAcs_01_sel_ff, vitAcs_01_sel_we,
                   vitAcs_01_pmOut, vitAcs_01_pmOut_or, vitAcs_01_pmOut_ff, vitAcs_01_pmOut_we,
                   vitAcs_01_sb, vitAcs_01_sb_ir, vitAcs_01_sb_fe, vitAcs_01_sb_re, 
                   vitAcs_01_pmIn0, vitAcs_01_pmIn0_ir, vitAcs_01_pmIn0_fe, vitAcs_01_pmIn0_re, 
                   vitAcs_01_pmIn1, vitAcs_01_pmIn1_ir, vitAcs_01_pmIn1_fe, vitAcs_01_pmIn1_re, 
                   vitAcs_01_run1, 
                   regBus, regWe, regRe, vitAcs_01_regWe, vitAcs_01_regRe, clk, clk2, reset);


//==============================================================================
