//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter uart16_wlan_txExtIf_w       = 16;

  // Outputs
  parameter uart16_wlan_rxExtIf_w       = 16;

  // Input control lines
  parameter uart16_wlan_rxs_w           = 1;

  // Output control lines
  parameter uart16_wlan_txs_w           = 1;

  // Eregs
  parameter uart16_wlan_div_w           = 14;
  parameter uart16_wlan_div_r           = WlanUartDivider_C;
  parameter uart16_wlan_div_s           = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam uart16_wlan.txExtIf_w       = uart16_wlan_txExtIf_w;
  defparam uart16_wlan.rxExtIf_w       = uart16_wlan_rxExtIf_w;
  defparam uart16_wlan.rxs_w           = uart16_wlan_rxs_w;
  defparam uart16_wlan.txs_w           = uart16_wlan_txs_w;
  defparam uart16_wlan.div_w           = uart16_wlan_div_w;
  defparam uart16_wlan.div_r           = uart16_wlan_div_r;
  defparam uart16_wlan.div_s           = uart16_wlan_div_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_uart16_wlan_div                                            = 0;
  defparam  uart16_wlan.R_div                                            = R_uart16_wlan_div;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire         [uart16_wlan_rxExtIf_w-1:0]  uart16_wlan_rxExtIf;
  wire                                      uart16_wlan_rxExtIf_or;
  wire                                      uart16_wlan_rxExtIf_ff;
  wire                                      uart16_wlan_rxExtIf_we;

  wire         [uart16_wlan_txExtIf_w-1:0]  uart16_wlan_txExtIf;
  wire                                      uart16_wlan_txExtIf_ir;
  wire                                      uart16_wlan_txExtIf_fe;
  wire                                      uart16_wlan_txExtIf_re;

  wire             [uart16_wlan_txs_w-1:0]  uart16_wlan_txs;

  wire             [uart16_wlan_rxs_w-1:0]  uart16_wlan_rxs;

  wire                                      uart16_wlan_regWe;
  wire                                      uart16_wlan_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  uart16 uart16_wlan(uart16_wlan_rxExtIf, uart16_wlan_rxExtIf_or, uart16_wlan_rxExtIf_ff, uart16_wlan_rxExtIf_we,
                     uart16_wlan_txExtIf, uart16_wlan_txExtIf_ir, uart16_wlan_txExtIf_fe, uart16_wlan_txExtIf_re, 
                     uart16_wlan_txs, 
                     uart16_wlan_rxs, 
                     regBus, regWe, regRe, uart16_wlan_regWe, uart16_wlan_regRe, clk, clk2, reset);


//==============================================================================
