//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   txRfCtrl
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module txRfCtrl(tCnt, tCnt_ir, tCnt_fe, tCnt_re, 
                paOn, 
                txOn, 
                bbOn, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter tCnt_w            = 0;

  parameter paOn_w            = 0;
  parameter txOn_w            = 0;
  parameter bbOn_w            = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter paDelay_w         = 0;
  parameter paDelay_r         = 0;
  parameter paDelay_s         = 0;
  parameter R_paDelay         = 0;
  parameter txDelay_w         = 0;
  parameter txDelay_r         = 0;
  parameter txDelay_s         = 0;
  parameter R_txDelay         = 0;
  parameter bbDelay_w         = 0;
  parameter bbDelay_r         = 0;
  parameter bbDelay_s         = 0;
  parameter R_bbDelay         = 0;

  parameter wt                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  input          [tCnt_w-1:0]  tCnt;
  output                       tCnt_ir;
  input                        tCnt_fe;
  output                       tCnt_re;
  assign                       tCnt_re = tCnt_ir & ~tCnt_fe;

  output         [paOn_w-1:0]  paOn;
  output         [txOn_w-1:0]  txOn;
  output         [bbOn_w-1:0]  bbOn;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire        [paDelay_w-1:0]  paDelay_q;
  wire        [paDelay_w-1:0]  paDelay_d;
  wire                         paDelay_weint;
  assign                       paDelay_weint = 0;

  wire        [txDelay_w-1:0]  txDelay_q;
  wire        [txDelay_w-1:0]  txDelay_d;
  wire                         txDelay_weint;
  assign                       txDelay_weint = 0;

  wire        [bbDelay_w-1:0]  bbDelay_q;
  wire        [bbDelay_w-1:0]  bbDelay_d;
  wire                         bbDelay_weint;
  assign                       bbDelay_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg paDelay(paDelay_q, regBus, paDelay_d, paDelay_weint, regWe, regRe, clk, reset);
  defparam paDelay.w    = paDelay_w;
  defparam paDelay.rval = paDelay_r;
  defparam paDelay.sgn  = paDelay_s;
  defparam paDelay.adr  = R_paDelay;

  ereg txDelay(txDelay_q, regBus, txDelay_d, txDelay_weint, regWe, regRe, clk, reset);
  defparam txDelay.w    = txDelay_w;
  defparam txDelay.rval = txDelay_r;
  defparam txDelay.sgn  = txDelay_s;
  defparam txDelay.adr  = R_txDelay;

  ereg bbDelay(bbDelay_q, regBus, bbDelay_d, bbDelay_weint, regWe, regRe, clk, reset);
  defparam bbDelay.w    = bbDelay_w;
  defparam bbDelay.rval = bbDelay_r;
  defparam bbDelay.sgn  = bbDelay_s;
  defparam bbDelay.adr  = R_bbDelay;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [wt-1:0]  cnt;
  reg        [0:0]  paOn;
  reg        [0:0]  txOn;
  reg        [0:0]  bbOn;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      cnt     <= 0;
      paOn    <= 0;
      txOn    <= 0;
      bbOn    <= 0;
      
    // Normal operation
    end else begin
      
      // Main counter
      if (paOn==0 | txOn==0 | bbOn==0) begin
        if (tCnt==1) begin
          cnt <= cnt+1;
        end
      end else begin
        cnt <= 0;
      end
      
      // Set PA/RF/BB on
      if (cnt==paDelay_q) begin
        paOn <= 1;
      end
      if (cnt==txDelay_q) begin
        txOn <= 1;
      end
      if (cnt==bbDelay_q) begin
        bbOn <= 1;
      end

    end // if (run1_q==0) ... else
  end // always

endmodule
//=========================================================================================

