//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter tx11b_0_x_w             = 8;

  // Outputs
  parameter tx11b_0_y_w             = 20;

  // Input control lines

  // Output control lines
  parameter tx11b_0_irqDone_w       = 1;

  // Eregs
  parameter tx11b_0_run1_w          = 1;
  parameter tx11b_0_run1_r          = 0;
  parameter tx11b_0_run1_s          = 0;

  // Parameters
  parameter tx11b_0_w               = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos
  parameter tx11b_0_ffMod2Src_w     = 4;
  parameter tx11b_0_ffMod2Src_n     = 4;
  parameter tx11b_0_ffMod2Src_m     = 3;

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam tx11b_0.x_w             = tx11b_0_x_w;
  defparam tx11b_0.y_w             = tx11b_0_y_w;
  defparam tx11b_0.irqDone_w       = tx11b_0_irqDone_w;
  defparam tx11b_0.run1_w          = tx11b_0_run1_w;
  defparam tx11b_0.run1_r          = tx11b_0_run1_r;
  defparam tx11b_0.run1_s          = tx11b_0_run1_s;
  defparam tx11b_0.w               = tx11b_0_w;
  defparam tx11b_0.ffMod2Src_w     = tx11b_0_ffMod2Src_w;
  defparam tx11b_0.ffMod2Src_m     = tx11b_0_ffMod2Src_m;
  defparam tx11b_0.ffMod2Src_n     = tx11b_0_ffMod2Src_n;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_tx11b_0_run1                                               = 0;
  defparam  tx11b_0.R_run1                                               = R_tx11b_0_run1;
  parameter R_tx11b_0_crc32_0_numBits                                    = 1;
  defparam  tx11b_0.R_crc32_0_numBits                                    = R_tx11b_0_crc32_0_numBits;
  parameter R_tx11b_0_ppdu11b_0_header                                   = 2;
  defparam  tx11b_0.R_ppdu11b_0_header                                   = R_tx11b_0_ppdu11b_0_header;
  parameter R_tx11b_0_ppdu11b_0_sfd                                      = 3;
  defparam  tx11b_0.R_ppdu11b_0_sfd                                      = R_tx11b_0_ppdu11b_0_sfd;
  parameter R_tx11b_0_ppdu11b_0_sigser                                   = 4;
  defparam  tx11b_0.R_ppdu11b_0_sigser                                   = R_tx11b_0_ppdu11b_0_sigser;
  parameter R_tx11b_0_ppdu11b_0_len                                      = 5;
  defparam  tx11b_0.R_ppdu11b_0_len                                      = R_tx11b_0_ppdu11b_0_len;
  parameter R_tx11b_0_ppdu11b_0_crc                                      = 6;
  defparam  tx11b_0.R_ppdu11b_0_crc                                      = R_tx11b_0_ppdu11b_0_crc;
  parameter R_tx11b_0_ppdu11b_0_numBits                                  = 7;
  defparam  tx11b_0.R_ppdu11b_0_numBits                                  = R_tx11b_0_ppdu11b_0_numBits;
  parameter R_tx11b_0_scrmbl_tx11b_s                                     = 8;
  defparam  tx11b_0.R_scrmbl_tx11b_s                                     = R_tx11b_0_scrmbl_tx11b_s;
  parameter R_tx11b_0_mod11b_0_mod11bBpsk_0_numBits                      = 9;
  defparam  tx11b_0.R_mod11b_0_mod11bBpsk_0_numBits                      = R_tx11b_0_mod11b_0_mod11bBpsk_0_numBits;
  parameter R_tx11b_0_mod11b_0_mod11bQpsk_0_numBits                      = 10;
  defparam  tx11b_0.R_mod11b_0_mod11bQpsk_0_numBits                      = R_tx11b_0_mod11b_0_mod11bQpsk_0_numBits;
  parameter R_tx11b_0_mod11b_0_mod11bCck_0_numBits                       = 11;
  defparam  tx11b_0.R_mod11b_0_mod11bCck_0_numBits                       = R_tx11b_0_mod11b_0_mod11bCck_0_numBits;
  parameter R_tx11b_0_mod11b_0_mod11bCck_0_mode1                         = 12;
  defparam  tx11b_0.R_mod11b_0_mod11bCck_0_mode1                         = R_tx11b_0_mod11b_0_mod11bCck_0_mode1;
  parameter R_tx11b_0_mod11b_0_modQpskZero_0_numZeros                    = 13;
  defparam  tx11b_0.R_mod11b_0_modQpskZero_0_numZeros                    = R_tx11b_0_mod11b_0_modQpskZero_0_numZeros;
  parameter R_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr                      = 14;
  defparam  tx11b_0.R_src11to20_0_lut_cf11bTx_wrAdr                      = R_tx11b_0_src11to20_0_lut_cf11bTx_wrAdr;
  parameter R_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi                    = 15;
  defparam  tx11b_0.R_src11to20_0_lut_cf11bTx_wrDatHi                    = R_tx11b_0_src11to20_0_lut_cf11bTx_wrDatHi;
  parameter R_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo                    = 16;
  defparam  tx11b_0.R_src11to20_0_lut_cf11bTx_wrDatLo                    = R_tx11b_0_src11to20_0_lut_cf11bTx_wrDatLo;
  parameter R_tx11b_0_src11to20_0_lut_cf11bTx_simInit                    = 17;
  defparam  tx11b_0.R_src11to20_0_lut_cf11bTx_simInit                    = R_tx11b_0_src11to20_0_lut_cf11bTx_simInit;

  // FIFO address definitions - might be overwritten by an upper module
  parameter R_tx11b_0_ffMod2Src                                          = 18;
  defparam  tx11b_0.R_ffMod2Src                                          = R_tx11b_0_ffMod2Src;

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [tx11b_0_y_w-1:0]  tx11b_0_y;
  wire                                      tx11b_0_y_or;
  wire                                      tx11b_0_y_ff;
  wire                                      tx11b_0_y_we;

  wire                   [tx11b_0_x_w-1:0]  tx11b_0_x;
  wire                                      tx11b_0_x_ir;
  wire                                      tx11b_0_x_fe;
  wire                                      tx11b_0_x_re;

  wire             [tx11b_0_irqDone_w-1:0]  tx11b_0_irqDone;

  wire                                      tx11b_0_regWe;
  wire                                      tx11b_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  tx11b tx11b_0(tx11b_0_y, tx11b_0_y_or, tx11b_0_y_ff, tx11b_0_y_we,
                tx11b_0_x, tx11b_0_x_ir, tx11b_0_x_fe, tx11b_0_x_re, 
                tx11b_0_irqDone, 
                regBus, regWe, regRe, tx11b_0_regWe, tx11b_0_regRe, clk, clk2, reset);


//==============================================================================
