//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   tx11b
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module tx11b(y, y_or, y_ff, y_we, 
             x, x_ir, x_fe, x_re, 
             irqDone, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter irqDone_w         = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;

  parameter ffMod2Src_w       = 0;
  parameter ffMod2Src_n       = 0;
  parameter ffMod2Src_m       = 0;
  parameter R_ffMod2Src       = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  output      [irqDone_w-1:0]  irqDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "byte2Bit_0.v"
  `include "crc32_0.v"
  `include "ppdu11b_0.v"
  `include "scrmbl_tx11b.v"
  `include "ins0Bit_0.v"
  `include "mod11b_0.v"
  `include "src11to20_0.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo mod11b_0_y -> src11to20_0_x11
  wire    [ffMod2Src_w-1:0]  ffMod2Src_q;
  wire                       ffMod2Src_fe;
  wire                       ffMod2Src_ff;
  wire                       ffMod2Src_ff2;
  wire                       ffMod2Src_fuf;
  wire                       ffMod2Src_fof;
  wire    [ffMod2Src_w-1:0]  ffMod2Src_d;
  wire                       ffMod2Src_re;
  wire                       ffMod2Src_we;
  wire                       ffMod2Src_ir;
  wire                       ffMod2Src_or;
  wire                       ffMod2Src_rst;

  fifoB ffMod2Src(ffMod2Src_q, ffMod2Src_fe, ffMod2Src_ff, ffMod2Src_ff2, ffMod2Src_fuf,
                  ffMod2Src_fof, ffMod2Src_d, ffMod2Src_re, ffMod2Src_we, ffMod2Src_ir,
                  ffMod2Src_or, ffMod2Src_rst, clk);
  defparam ffMod2Src.w = ffMod2Src_w;
  defparam ffMod2Src.m = ffMod2Src_m;
  defparam ffMod2Src.n = ffMod2Src_n;
  defparam ffMod2Src.a = R_ffMod2Src;

  assign ffMod2Src_d               = mod11b_0_y;
  assign ffMod2Src_we              = mod11b_0_y_we;
  assign mod11b_0_y_ff             = ffMod2Src_ff;
  assign ffMod2Src_or              = mod11b_0_y_or;

  assign src11to20_0_x11           = ffMod2Src_q;
  assign src11to20_0_x11_fe        = ffMod2Src_fe;
  assign ffMod2Src_re              = src11to20_0_x11_re;
  assign ffMod2Src_ir              = src11to20_0_x11_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign byte2Bit_0_x              = x;
  assign byte2Bit_0_x_fe           = x_fe;
  assign x_ir                      = byte2Bit_0_x_ir;

  assign crc32_0_x                 = byte2Bit_0_y;
  assign crc32_0_x_fe              = ~byte2Bit_0_y_or;
  assign byte2Bit_0_y_ff           = ~crc32_0_x_ir;

  assign ppdu11b_0_x               = crc32_0_y;
  assign ppdu11b_0_x_fe            = ~crc32_0_y_or;
  assign crc32_0_y_ff              = ~ppdu11b_0_x_ir;

  assign ins0Bit_0_x               = scrmbl_tx11b_y;
  assign ins0Bit_0_x_fe            = ~scrmbl_tx11b_y_or;
  assign scrmbl_tx11b_y_ff         = ~ins0Bit_0_x_ir;

  assign mod11b_0_x                = ins0Bit_0_y;
  assign mod11b_0_x_fe             = ~ins0Bit_0_y_or;
  assign ins0Bit_0_y_ff            = ~mod11b_0_x_ir;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | byte2Bit_0_regWe | crc32_0_regWe | ppdu11b_0_regWe
                      | scrmbl_tx11b_regWe | ins0Bit_0_regWe | mod11b_0_regWe
                      | src11to20_0_regWe;
  assign regReOut = 0 | byte2Bit_0_regRe | crc32_0_regRe | ppdu11b_0_regRe
                      | scrmbl_tx11b_regRe | ins0Bit_0_regRe | mod11b_0_regRe
                      | src11to20_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Additional registers
  reg  [8:0]  runCnt; 
  reg         runPpdu, runSrc, runScr, runCrc;
  reg         modFeD;                           // Delayed FIFO empty

  // Delay chain for run1
  always @(posedge clk) begin
    
    if (run1_q==0) begin
      runCnt  <= 0;
      runPpdu <= 0;
      runScr  <= 0;
      runSrc  <= 0;
      runCrc  <= 0;
    
    end else begin
      runCnt  <= runCnt + 1;
      if (runCnt==2) begin
        runSrc <= 1;
      end
      if (runCnt==70) begin // Seems that 76/77 is the maximum
        runPpdu <= 1;       // for these delays, so use a bit
      end                   // of margin just in case a minor
      if (runCnt==71) begin // change is made
        runScr <= 1;
      end
      if (runCnt==511) begin // Delay this a bit to give input some time
        runCrc <= 1;         // (not really needed if input data is early)
      end
    end
  end
  
  // Trace FIFO empty flag to produce irqDone
  always @(posedge clk) begin
    if (run1_q==0) begin
      modFeD <= 1;
    end else begin
      modFeD <= ffMod2Src_fe;
    end
  end
  assign irqDone = (run1_q==1) && (modFeD==0) && (ffMod2Src_fe==1);

  // Delayed run line for modules
  assign byte2Bit_0_run1        = runCrc;
  assign crc32_0_run1           = runCrc;
  assign ppdu11b_0_run1         = runPpdu;
  assign scrmbl_tx11b_run1      = runScr;
  assign ins0Bit_0_run1         = run1_q;
  assign mod11b_0_run1          = run1_q;
  assign src11to20_0_run1       = runSrc;
  
  // Manual connection - delayed run line for modules
  assign scrmbl_tx11b_scrMode   = 1;
  assign scrmbl_tx11b_xs[0]     = ppdu11b_0_y;
  assign scrmbl_tx11b_xs[1]     = 1;
  assign scrmbl_tx11b_xs_fe     = ~ppdu11b_0_y_or;
  assign ppdu11b_0_y_ff         = ~scrmbl_tx11b_xs_ir;

  // Reset FIFO
  assign ffMod2Src_rst  = run1_q==0;

  // Split the output of the src11to20 (2*6 bit on 1 port) into real/imag, expand to 10 bit each
  assign y    = { {{1{src11to20_0_x20[11]}}, src11to20_0_x20[11:6], 3'b0}, 
                  {{1{src11to20_0_x20[ 5]}}, src11to20_0_x20[ 5:0], 3'b0} };
  assign y_or = src11to20_0_x20_or;
  assign src11to20_0_x20_ff = y_ff;

endmodule
//=========================================================================================

