//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   tx11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module tx11a(y, y_or, y_ff, y_we, 
             yFft, yFft_or, yFft_ff, yFft_we, 
             x, x_ir, x_fe, x_re, 
             xFft, xFft_ir, xFft_fe, xFft_re, 
             irqDone, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yFft_w            = 0;
  parameter x_w               = 0;
  parameter xFft_w            = 0;

  parameter irqDone_w         = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output         [yFft_w-1:0]  yFft;
  output                       yFft_or;
  input                        yFft_ff;
  output                       yFft_we;
  assign                       yFft_we = yFft_or & ~yFft_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [xFft_w-1:0]  xFft;
  output                       xFft_ir;
  input                        xFft_fe;
  output                       xFft_re;
  assign                       xFft_re = xFft_ir & ~xFft_fe;

  output      [irqDone_w-1:0]  irqDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "enc11a_0.v"
  `include "mod11a_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign enc11a_0_x                = x;
  assign enc11a_0_x_fe             = x_fe;
  assign x_ir                      = enc11a_0_x_ir;

  assign mod11a_0_xFft             = xFft;
  assign mod11a_0_xFft_fe          = xFft_fe;
  assign xFft_ir                   = mod11a_0_xFft_ir;

  assign mod11a_0_x                = enc11a_0_y;
  assign mod11a_0_x_fe             = ~enc11a_0_y_or;
  assign enc11a_0_y_ff             = ~mod11a_0_x_ir;

  assign yFft                      = mod11a_0_yFft;
  assign yFft_or                   = mod11a_0_yFft_or;
  assign mod11a_0_yFft_ff          = yFft_ff;

  assign y                         = mod11a_0_y;
  assign y_or                      = mod11a_0_y_or;
  assign mod11a_0_y_ff             = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | enc11a_0_regWe | mod11a_0_regWe;
  assign regReOut = 0 | enc11a_0_regRe | mod11a_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // Pass IRQ done to main module
  assign irqDone = mod11a_0_irqDone;

endmodule
//=========================================================================================

