//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs

  // Outputs

  // Input control lines

  // Output control lines
  parameter timer_0_irqOut_w        = 2;
  parameter timer_0_tCnt_w          = 1;

  // Eregs
  parameter timer_0_run1_w          = 2;
  parameter timer_0_run1_r          = 0;
  parameter timer_0_run1_s          = 0;
  parameter timer_0_timeLo_w        = 0;
  parameter timer_0_timeLo_r        = 0;
  parameter timer_0_timeLo_s        = 0;
  parameter timer_0_timeHi_w        = 0;
  parameter timer_0_timeHi_r        = 0;
  parameter timer_0_timeHi_s        = 0;
  parameter timer_0_irqEn0_w        = 1;
  parameter timer_0_irqEn0_r        = 0;
  parameter timer_0_irqEn0_s        = 0;
  parameter timer_0_irqEn1_w        = 1;
  parameter timer_0_irqEn1_r        = 0;
  parameter timer_0_irqEn1_s        = 0;
  parameter timer_0_tMatch0Lo_w     = 16;
  parameter timer_0_tMatch0Lo_r     = 0;
  parameter timer_0_tMatch0Lo_s     = 0;
  parameter timer_0_tMatch0Hi_w     = 16;
  parameter timer_0_tMatch0Hi_r     = 0;
  parameter timer_0_tMatch0Hi_s     = 0;
  parameter timer_0_tMatch1Lo_w     = 16;
  parameter timer_0_tMatch1Lo_r     = 0;
  parameter timer_0_tMatch1Lo_s     = 0;
  parameter timer_0_tMatch1Hi_w     = 16;
  parameter timer_0_tMatch1Hi_r     = 0;
  parameter timer_0_tMatch1Hi_s     = 0;
  parameter timer_0_pLo16_w         = 16;
  parameter timer_0_pLo16_r         = 1;
  parameter timer_0_pLo16_s         = 0;
  parameter timer_0_pHi16_w         = 16;
  parameter timer_0_pHi16_r         = 0;
  parameter timer_0_pHi16_s         = 0;
  parameter timer_0_qLo16_w         = 16;
  parameter timer_0_qLo16_r         = 4;
  parameter timer_0_qLo16_s         = 0;
  parameter timer_0_qHi16_w         = 16;
  parameter timer_0_qHi16_r         = 0;
  parameter timer_0_qHi16_s         = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam timer_0.irqOut_w        = timer_0_irqOut_w;
  defparam timer_0.tCnt_w          = timer_0_tCnt_w;
  defparam timer_0.run1_w          = timer_0_run1_w;
  defparam timer_0.run1_r          = timer_0_run1_r;
  defparam timer_0.run1_s          = timer_0_run1_s;
  defparam timer_0.timeLo_w        = timer_0_timeLo_w;
  defparam timer_0.timeLo_r        = timer_0_timeLo_r;
  defparam timer_0.timeLo_s        = timer_0_timeLo_s;
  defparam timer_0.timeHi_w        = timer_0_timeHi_w;
  defparam timer_0.timeHi_r        = timer_0_timeHi_r;
  defparam timer_0.timeHi_s        = timer_0_timeHi_s;
  defparam timer_0.irqEn0_w        = timer_0_irqEn0_w;
  defparam timer_0.irqEn0_r        = timer_0_irqEn0_r;
  defparam timer_0.irqEn0_s        = timer_0_irqEn0_s;
  defparam timer_0.irqEn1_w        = timer_0_irqEn1_w;
  defparam timer_0.irqEn1_r        = timer_0_irqEn1_r;
  defparam timer_0.irqEn1_s        = timer_0_irqEn1_s;
  defparam timer_0.tMatch0Lo_w     = timer_0_tMatch0Lo_w;
  defparam timer_0.tMatch0Lo_r     = timer_0_tMatch0Lo_r;
  defparam timer_0.tMatch0Lo_s     = timer_0_tMatch0Lo_s;
  defparam timer_0.tMatch0Hi_w     = timer_0_tMatch0Hi_w;
  defparam timer_0.tMatch0Hi_r     = timer_0_tMatch0Hi_r;
  defparam timer_0.tMatch0Hi_s     = timer_0_tMatch0Hi_s;
  defparam timer_0.tMatch1Lo_w     = timer_0_tMatch1Lo_w;
  defparam timer_0.tMatch1Lo_r     = timer_0_tMatch1Lo_r;
  defparam timer_0.tMatch1Lo_s     = timer_0_tMatch1Lo_s;
  defparam timer_0.tMatch1Hi_w     = timer_0_tMatch1Hi_w;
  defparam timer_0.tMatch1Hi_r     = timer_0_tMatch1Hi_r;
  defparam timer_0.tMatch1Hi_s     = timer_0_tMatch1Hi_s;
  defparam timer_0.pLo16_w         = timer_0_pLo16_w;
  defparam timer_0.pLo16_r         = timer_0_pLo16_r;
  defparam timer_0.pLo16_s         = timer_0_pLo16_s;
  defparam timer_0.pHi16_w         = timer_0_pHi16_w;
  defparam timer_0.pHi16_r         = timer_0_pHi16_r;
  defparam timer_0.pHi16_s         = timer_0_pHi16_s;
  defparam timer_0.qLo16_w         = timer_0_qLo16_w;
  defparam timer_0.qLo16_r         = timer_0_qLo16_r;
  defparam timer_0.qLo16_s         = timer_0_qLo16_s;
  defparam timer_0.qHi16_w         = timer_0_qHi16_w;
  defparam timer_0.qHi16_r         = timer_0_qHi16_r;
  defparam timer_0.qHi16_s         = timer_0_qHi16_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_timer_0_run1                                               = 0;
  defparam  timer_0.R_run1                                               = R_timer_0_run1;
  parameter R_timer_0_timeLo                                             = 1;
  defparam  timer_0.R_timeLo                                             = R_timer_0_timeLo;
  parameter R_timer_0_timeHi                                             = 2;
  defparam  timer_0.R_timeHi                                             = R_timer_0_timeHi;
  parameter R_timer_0_irqEn0                                             = 3;
  defparam  timer_0.R_irqEn0                                             = R_timer_0_irqEn0;
  parameter R_timer_0_irqEn1                                             = 4;
  defparam  timer_0.R_irqEn1                                             = R_timer_0_irqEn1;
  parameter R_timer_0_tMatch0Lo                                          = 5;
  defparam  timer_0.R_tMatch0Lo                                          = R_timer_0_tMatch0Lo;
  parameter R_timer_0_tMatch0Hi                                          = 6;
  defparam  timer_0.R_tMatch0Hi                                          = R_timer_0_tMatch0Hi;
  parameter R_timer_0_tMatch1Lo                                          = 7;
  defparam  timer_0.R_tMatch1Lo                                          = R_timer_0_tMatch1Lo;
  parameter R_timer_0_tMatch1Hi                                          = 8;
  defparam  timer_0.R_tMatch1Hi                                          = R_timer_0_tMatch1Hi;
  parameter R_timer_0_pLo16                                              = 9;
  defparam  timer_0.R_pLo16                                              = R_timer_0_pLo16;
  parameter R_timer_0_pHi16                                              = 10;
  defparam  timer_0.R_pHi16                                              = R_timer_0_pHi16;
  parameter R_timer_0_qLo16                                              = 11;
  defparam  timer_0.R_qLo16                                              = R_timer_0_qLo16;
  parameter R_timer_0_qHi16                                              = 12;
  defparam  timer_0.R_qHi16                                              = R_timer_0_qHi16;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [timer_0_irqOut_w-1:0]  timer_0_irqOut;
  wire                [timer_0_tCnt_w-1:0]  timer_0_tCnt;

  wire                                      timer_0_regWe;
  wire                                      timer_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  timer timer_0(timer_0_irqOut, 
                timer_0_tCnt, 
                regBus, regWe, regRe, timer_0_regWe, timer_0_regRe, clk, clk2, reset);


//==============================================================================
