//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   timer
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module timer(irqOut, 
             tCnt, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters

  parameter irqOut_w          = 0;
  parameter tCnt_w            = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter timeLo_w          = 0;
  parameter timeLo_r          = 0;
  parameter timeLo_s          = 0;
  parameter R_timeLo          = 0;
  parameter timeHi_w          = 0;
  parameter timeHi_r          = 0;
  parameter timeHi_s          = 0;
  parameter R_timeHi          = 0;
  parameter irqEn0_w          = 0;
  parameter irqEn0_r          = 0;
  parameter irqEn0_s          = 0;
  parameter R_irqEn0          = 0;
  parameter irqEn1_w          = 0;
  parameter irqEn1_r          = 0;
  parameter irqEn1_s          = 0;
  parameter R_irqEn1          = 0;
  parameter tMatch0Lo_w       = 0;
  parameter tMatch0Lo_r       = 0;
  parameter tMatch0Lo_s       = 0;
  parameter R_tMatch0Lo       = 0;
  parameter tMatch0Hi_w       = 0;
  parameter tMatch0Hi_r       = 0;
  parameter tMatch0Hi_s       = 0;
  parameter R_tMatch0Hi       = 0;
  parameter tMatch1Lo_w       = 0;
  parameter tMatch1Lo_r       = 0;
  parameter tMatch1Lo_s       = 0;
  parameter R_tMatch1Lo       = 0;
  parameter tMatch1Hi_w       = 0;
  parameter tMatch1Hi_r       = 0;
  parameter tMatch1Hi_s       = 0;
  parameter R_tMatch1Hi       = 0;
  parameter pLo16_w           = 0;
  parameter pLo16_r           = 0;
  parameter pLo16_s           = 0;
  parameter R_pLo16           = 0;
  parameter pHi16_w           = 0;
  parameter pHi16_r           = 0;
  parameter pHi16_s           = 0;
  parameter R_pHi16           = 0;
  parameter qLo16_w           = 0;
  parameter qLo16_r           = 0;
  parameter qLo16_s           = 0;
  parameter R_qLo16           = 0;
  parameter qHi16_w           = 0;
  parameter qHi16_r           = 0;
  parameter qHi16_s           = 0;
  parameter R_qHi16           = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output       [irqOut_w-1:0]  irqOut;
  output         [tCnt_w-1:0]  tCnt;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire         [irqEn0_w-1:0]  irqEn0_q;
  wire         [irqEn0_w-1:0]  irqEn0_d;
  wire                         irqEn0_weint;
  assign                       irqEn0_weint = 0;

  wire         [irqEn1_w-1:0]  irqEn1_q;
  wire         [irqEn1_w-1:0]  irqEn1_d;
  wire                         irqEn1_weint;
  assign                       irqEn1_weint = 0;

  wire      [tMatch0Lo_w-1:0]  tMatch0Lo_q;
  wire      [tMatch0Lo_w-1:0]  tMatch0Lo_d;
  wire                         tMatch0Lo_weint;
  assign                       tMatch0Lo_weint = 0;

  wire      [tMatch0Hi_w-1:0]  tMatch0Hi_q;
  wire      [tMatch0Hi_w-1:0]  tMatch0Hi_d;
  wire                         tMatch0Hi_weint;
  assign                       tMatch0Hi_weint = 0;

  wire      [tMatch1Lo_w-1:0]  tMatch1Lo_q;
  wire      [tMatch1Lo_w-1:0]  tMatch1Lo_d;
  wire                         tMatch1Lo_weint;
  assign                       tMatch1Lo_weint = 0;

  wire      [tMatch1Hi_w-1:0]  tMatch1Hi_q;
  wire      [tMatch1Hi_w-1:0]  tMatch1Hi_d;
  wire                         tMatch1Hi_weint;
  assign                       tMatch1Hi_weint = 0;

  wire          [pLo16_w-1:0]  pLo16_q;
  wire          [pLo16_w-1:0]  pLo16_d;
  wire                         pLo16_weint;
  assign                       pLo16_weint = 0;

  wire          [pHi16_w-1:0]  pHi16_q;
  wire          [pHi16_w-1:0]  pHi16_d;
  wire                         pHi16_weint;
  assign                       pHi16_weint = 0;

  wire          [qLo16_w-1:0]  qLo16_q;
  wire          [qLo16_w-1:0]  qLo16_d;
  wire                         qLo16_weint;
  assign                       qLo16_weint = 0;

  wire          [qHi16_w-1:0]  qHi16_q;
  wire          [qHi16_w-1:0]  qHi16_d;
  wire                         qHi16_weint;
  assign                       qHi16_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg irqEn0(irqEn0_q, regBus, irqEn0_d, irqEn0_weint, regWe, regRe, clk, reset);
  defparam irqEn0.w    = irqEn0_w;
  defparam irqEn0.rval = irqEn0_r;
  defparam irqEn0.sgn  = irqEn0_s;
  defparam irqEn0.adr  = R_irqEn0;

  ereg irqEn1(irqEn1_q, regBus, irqEn1_d, irqEn1_weint, regWe, regRe, clk, reset);
  defparam irqEn1.w    = irqEn1_w;
  defparam irqEn1.rval = irqEn1_r;
  defparam irqEn1.sgn  = irqEn1_s;
  defparam irqEn1.adr  = R_irqEn1;

  ereg tMatch0Lo(tMatch0Lo_q, regBus, tMatch0Lo_d, tMatch0Lo_weint, regWe, regRe, clk, reset);
  defparam tMatch0Lo.w    = tMatch0Lo_w;
  defparam tMatch0Lo.rval = tMatch0Lo_r;
  defparam tMatch0Lo.sgn  = tMatch0Lo_s;
  defparam tMatch0Lo.adr  = R_tMatch0Lo;

  ereg tMatch0Hi(tMatch0Hi_q, regBus, tMatch0Hi_d, tMatch0Hi_weint, regWe, regRe, clk, reset);
  defparam tMatch0Hi.w    = tMatch0Hi_w;
  defparam tMatch0Hi.rval = tMatch0Hi_r;
  defparam tMatch0Hi.sgn  = tMatch0Hi_s;
  defparam tMatch0Hi.adr  = R_tMatch0Hi;

  ereg tMatch1Lo(tMatch1Lo_q, regBus, tMatch1Lo_d, tMatch1Lo_weint, regWe, regRe, clk, reset);
  defparam tMatch1Lo.w    = tMatch1Lo_w;
  defparam tMatch1Lo.rval = tMatch1Lo_r;
  defparam tMatch1Lo.sgn  = tMatch1Lo_s;
  defparam tMatch1Lo.adr  = R_tMatch1Lo;

  ereg tMatch1Hi(tMatch1Hi_q, regBus, tMatch1Hi_d, tMatch1Hi_weint, regWe, regRe, clk, reset);
  defparam tMatch1Hi.w    = tMatch1Hi_w;
  defparam tMatch1Hi.rval = tMatch1Hi_r;
  defparam tMatch1Hi.sgn  = tMatch1Hi_s;
  defparam tMatch1Hi.adr  = R_tMatch1Hi;

  ereg pLo16(pLo16_q, regBus, pLo16_d, pLo16_weint, regWe, regRe, clk, reset);
  defparam pLo16.w    = pLo16_w;
  defparam pLo16.rval = pLo16_r;
  defparam pLo16.sgn  = pLo16_s;
  defparam pLo16.adr  = R_pLo16;

  ereg pHi16(pHi16_q, regBus, pHi16_d, pHi16_weint, regWe, regRe, clk, reset);
  defparam pHi16.w    = pHi16_w;
  defparam pHi16.rval = pHi16_r;
  defparam pHi16.sgn  = pHi16_s;
  defparam pHi16.adr  = R_pHi16;

  ereg qLo16(qLo16_q, regBus, qLo16_d, qLo16_weint, regWe, regRe, clk, reset);
  defparam qLo16.w    = qLo16_w;
  defparam qLo16.rval = qLo16_r;
  defparam qLo16.sgn  = qLo16_s;
  defparam qLo16.adr  = R_qLo16;

  ereg qHi16(qHi16_q, regBus, qHi16_d, qHi16_weint, regWe, regRe, clk, reset);
  defparam qHi16.w    = qHi16_w;
  defparam qHi16.rval = qHi16_r;
  defparam qHi16.sgn  = qHi16_s;
  defparam qHi16.adr  = R_qHi16;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Define output as register
  reg     [irqOut_w-1:0] irqOut;
  reg       [tCnt_w-1:0] tCnt;

  // Other register definitions
  reg     [31:0]  time32;
  reg     [15:0]  timeBuf;
  reg             rdTimeLo;
  reg             rdTimeHi;
  reg             wrTimeLo;
  reg             wrTimeHi;
  
  reg     [31:0]  cnt;
  wire    [32:0]  cnt0, cnt1;
  wire    [32:0]  p, q;

  // --------------------------------------------------------------------------------------
  // Prescale processing
  assign p    = {1'b0, pHi16_q, pLo16_q};       // p = 33 bit, unsigned extension
  assign q    = {1'b0, qHi16_q, qLo16_q};       // q = 33 bit, unsigned extension
  assign cnt0 = {1'b0, cnt} - p;
  assign cnt1 = cnt0 + q;
  
  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin

    // Reset
    if (run1_q==0) begin
      cnt       <= q[31:0];
      time32    <= 0;
      rdTimeLo  <= 0;
      rdTimeHi  <= 0;
      wrTimeLo  <= 0;
      wrTimeHi  <= 0;
      irqOut    <= 0;
      tCnt      <= 0;
      
    // Normal operation
    end else begin
      
      // Prescaler: if cnt0 <= 0, cnt = cnt-p+q, else cnt = cnt-p
      if (run1_q==1) begin
        if (cnt0[32] == 1) begin
          cnt   <= cnt1[31:0];
          tCnt  <= 1;
        end else begin
          cnt   <= cnt0[31:0];
          tCnt  <= 0;
        end
      end

      // Save read/write signals
      rdTimeLo <= regBus==R_timeLo & regRe;
      rdTimeHi <= regBus==R_timeHi & regRe;
      wrTimeLo <= regBus==R_timeLo & regWe;
      wrTimeHi <= regBus==R_timeHi & regWe;

      // Write time buffer if timer low word is written or read
      if (rdTimeLo) begin
        timeBuf <= time32[31:16];
      end else
      if (wrTimeLo) begin
        timeBuf <= regBus;
      end

      // Update / set time32
      if (wrTimeHi) begin
        time32 <= {regBus, timeBuf};
      end else begin
        if (tCnt==1 & run1_q==1) begin
          time32 <= time32+1;
        end
      end

      // IRQs
      irqOut[0] <= irqEn0_q & run1_q==1 & tCnt==1 & time32=={tMatch0Hi_q, tMatch0Lo_q};
      irqOut[1] <= irqEn1_q & run1_q==1 & tCnt==1 & time32=={tMatch1Hi_q, tMatch1Lo_q};

    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Assign regBus while reading
  assign regBus = rdTimeLo ? time32[15:0] : 
                  rdTimeHi ? timeBuf      :
                  16'bz;

endmodule
//=========================================================================================

