//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter thrPass_0_x_w             = 24;

  // Outputs
  parameter thrPass_0_y_w             = 24;

  // Input control lines

  // Output control lines

  // Eregs
  parameter thrPass_0_run1_w          = 1;
  parameter thrPass_0_run1_r          = 0;
  parameter thrPass_0_run1_s          = 0;
  parameter thrPass_0_thr_w           = 11;
  parameter thrPass_0_thr_r           = 0;
  parameter thrPass_0_thr_s           = 0;
  parameter thrPass_0_trig_w          = 1;
  parameter thrPass_0_trig_r          = 0;
  parameter thrPass_0_trig_s          = 0;

  // Parameters
  parameter thrPass_0_w               = 12;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam thrPass_0.x_w             = thrPass_0_x_w;
  defparam thrPass_0.y_w             = thrPass_0_y_w;
  defparam thrPass_0.run1_w          = thrPass_0_run1_w;
  defparam thrPass_0.run1_r          = thrPass_0_run1_r;
  defparam thrPass_0.run1_s          = thrPass_0_run1_s;
  defparam thrPass_0.thr_w           = thrPass_0_thr_w;
  defparam thrPass_0.thr_r           = thrPass_0_thr_r;
  defparam thrPass_0.thr_s           = thrPass_0_thr_s;
  defparam thrPass_0.trig_w          = thrPass_0_trig_w;
  defparam thrPass_0.trig_r          = thrPass_0_trig_r;
  defparam thrPass_0.trig_s          = thrPass_0_trig_s;
  defparam thrPass_0.w               = thrPass_0_w;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_thrPass_0_run1                                             = 0;
  defparam  thrPass_0.R_run1                                             = R_thrPass_0_run1;
  parameter R_thrPass_0_thr                                              = 1;
  defparam  thrPass_0.R_thr                                              = R_thrPass_0_thr;
  parameter R_thrPass_0_trig                                             = 2;
  defparam  thrPass_0.R_trig                                             = R_thrPass_0_trig;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [thrPass_0_y_w-1:0]  thrPass_0_y;
  wire                                      thrPass_0_y_or;
  wire                                      thrPass_0_y_ff;
  wire                                      thrPass_0_y_we;

  wire                 [thrPass_0_x_w-1:0]  thrPass_0_x;
  wire                                      thrPass_0_x_ir;
  wire                                      thrPass_0_x_fe;
  wire                                      thrPass_0_x_re;

  wire                                      thrPass_0_regWe;
  wire                                      thrPass_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  thrPass thrPass_0(thrPass_0_y, thrPass_0_y_or, thrPass_0_y_ff, thrPass_0_y_we,
                    thrPass_0_x, thrPass_0_x_ir, thrPass_0_x_fe, thrPass_0_x_re, 
                    regBus, regWe, regRe, thrPass_0_regWe, thrPass_0_regRe, clk, clk2, reset);


//==============================================================================
