//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   thrPass
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module thrPass(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;
  parameter thr_w             = 0;
  parameter thr_r             = 0;
  parameter thr_s             = 0;
  parameter R_thr             = 0;
  parameter trig_w            = 0;
  parameter trig_r            = 0;
  parameter trig_s            = 0;
  parameter R_trig            = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  wire            [thr_w-1:0]  thr_q;
  wire            [thr_w-1:0]  thr_d;
  wire                         thr_weint;
  assign                       thr_weint = 0;

  wire           [trig_w-1:0]  trig_q;
  wire           [trig_w-1:0]  trig_d;
  wire                         trig_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  ereg thr(thr_q, regBus, thr_d, thr_weint, regWe, regRe, clk, reset);
  defparam thr.w    = thr_w;
  defparam thr.rval = thr_r;
  defparam thr.sgn  = thr_s;
  defparam thr.adr  = R_thr;

  ereg trig(trig_q, regBus, trig_d, trig_weint, regWe, regRe, clk, reset);
  defparam trig.w    = trig_w;
  defparam trig.rval = trig_r;
  defparam trig.sgn  = trig_s;
  defparam trig.adr  = R_trig;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg     [w-1:0]   xIn;
  reg     [w-1:0]   xAbs;
  reg     [w-1:0]   xDiff;
  reg               xVld;
  reg               tgl;
  reg               pass;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir = run1_q;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
    
    // Multiplex input, calculated abs value
    xIn   = tgl==0      ? x[w-1:0] : x[2*w-1:w];
    xAbs  = xIn[w-1]==0 ? xIn : -xIn;
    xDiff = xAbs - {1'b0, thr_q};
    xVld  = xDiff[w-1]==0;
        
  end

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1_q==0) begin
      tgl  <= 0;
      pass <= 0;
                  
    // Normal operation
    end else begin
      
      // Register update 1
      if (x_re) begin
        
        // Toggle input flag
        tgl <= ~tgl;
        
        // Pass input to output
        if (xVld) begin
          pass <= 1;
        end
        
      end

    end // if (run1_q==0) ... else
  end // always

  // --------------------------------------------------------------------------------------
  // Capture trigger signal
  assign trig_d     = pass;
  assign trig_weint = 1;

  // --------------------------------------------------------------------------------------
  // Assign output enable
  assign y_or = pass & x_re;
  assign y    = x;
  
endmodule
//=========================================================================================

