//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   sync11a
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module sync11a(yC, yC_or, yC_ff, yC_we, 
               ySh, ySh_or, ySh_ff, ySh_we, 
               yFft, yFft_or, yFft_ff, yFft_we, 
               yAbs, yAbs_or, yAbs_ff, yAbs_we, 
               x, x_ir, x_fe, x_re, 
               xu, xu_ir, xu_fe, xu_re, 
               xFft, xFft_ir, xFft_fe, xFft_re, 
               irqDone, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Include global definitions
  `include "def_Const_wlan.v"

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yC_w              = 0;
  parameter ySh_w             = 0;
  parameter yFft_w            = 0;
  parameter yAbs_w            = 0;
  parameter x_w               = 0;
  parameter xu_w              = 0;
  parameter xFft_w            = 0;

  parameter irqDone_w         = 0;

  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;
  parameter wu                = 0;
  parameter ws                = 0;
  parameter modeFte           = 0;
  parameter modeFfe           = 0;
  parameter modeAmpEst        = 0;
  parameter modeChEst         = 0;
  parameter modeChCor         = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output           [yC_w-1:0]  yC;
  output                       yC_or;
  input                        yC_ff;
  output                       yC_we;
  assign                       yC_we = yC_or & ~yC_ff;

  output          [ySh_w-1:0]  ySh;
  output                       ySh_or;
  input                        ySh_ff;
  output                       ySh_we;
  assign                       ySh_we = ySh_or & ~ySh_ff;

  output         [yFft_w-1:0]  yFft;
  output                       yFft_or;
  input                        yFft_ff;
  output                       yFft_we;
  assign                       yFft_we = yFft_or & ~yFft_ff;

  output         [yAbs_w-1:0]  yAbs;
  output                       yAbs_or;
  input                        yAbs_ff;
  output                       yAbs_we;
  assign                       yAbs_we = yAbs_or & ~yAbs_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input            [xu_w-1:0]  xu;
  output                       xu_ir;
  input                        xu_fe;
  output                       xu_re;
  assign                       xu_re = xu_ir & ~xu_fe;

  input          [xFft_w-1:0]  xFft;
  output                       xFft_ir;
  input                        xFft_fe;
  output                       xFft_re;
  assign                       xFft_re = xFft_ir & ~xFft_fe;

  output      [irqDone_w-1:0]  irqDone;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "lsCcf_0.v"
  `include "wnrFilt_0.v"
  `include "cxMulAvg_0.v"
  `include "cDeIntlv_0.v"
  `include "pltDel_0.v"
  `include "memReplay_52x20.v"
  `include "s1To2Sel_20a.v"
  `include "s1To2Sel_20b.v"
  `include "s1To2Sel_20c.v"
  `include "s2To1Sel_20.v"
  `include "s1To2And_20.v"
  `include "s4To1Sel_20.v"
  `include "s2To1Ilv_20.v"
  `include "buf2_20.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign lsCcf_0_xFft              = xFft;
  assign lsCcf_0_xFft_fe           = xFft_fe;
  assign xFft_ir                   = lsCcf_0_xFft_ir;

  assign lsCcf_0_x                 = s1To2Sel_20a_y0;
  assign lsCcf_0_x_fe              = ~s1To2Sel_20a_y0_or;
  assign s1To2Sel_20a_y0_ff        = ~lsCcf_0_x_ir;

  assign s4To1Sel_20_x1            = s1To2Sel_20a_y1;
  assign s4To1Sel_20_x1_fe         = ~s1To2Sel_20a_y1_or;
  assign s1To2Sel_20a_y1_ff        = ~s4To1Sel_20_x1_ir;

  assign s1To2Sel_20c_x            = lsCcf_0_yC;
  assign s1To2Sel_20c_x_fe         = ~lsCcf_0_yC_or;
  assign lsCcf_0_yC_ff             = ~s1To2Sel_20c_x_ir;

  assign yFft                      = lsCcf_0_yFft;
  assign yFft_or                   = lsCcf_0_yFft_or;
  assign lsCcf_0_yFft_ff           = yFft_ff;

  assign yAbs                      = lsCcf_0_yAbs;
  assign yAbs_or                   = lsCcf_0_yAbs_or;
  assign lsCcf_0_yAbs_ff           = yAbs_ff;

  assign wnrFilt_0_x               = s1To2Sel_20c_y0;
  assign wnrFilt_0_x_fe            = ~s1To2Sel_20c_y0_or;
  assign s1To2Sel_20c_y0_ff        = ~wnrFilt_0_x_ir;

  assign s2To1Sel_20_x1            = s1To2Sel_20c_y1;
  assign s2To1Sel_20_x1_fe         = ~s1To2Sel_20c_y1_or;
  assign s1To2Sel_20c_y1_ff        = ~s2To1Sel_20_x1_ir;

  assign s2To1Sel_20_x0            = wnrFilt_0_y;
  assign s2To1Sel_20_x0_fe         = ~wnrFilt_0_y_or;
  assign wnrFilt_0_y_ff            = ~s2To1Sel_20_x0_ir;

  assign cDeIntlv_0_x              = s2To1Sel_20_y;
  assign cDeIntlv_0_x_fe           = ~s2To1Sel_20_y_or;
  assign s2To1Sel_20_y_ff          = ~cDeIntlv_0_x_ir;

  assign s1To2Sel_20b_x            = cDeIntlv_0_y;
  assign s1To2Sel_20b_x_fe         = ~cDeIntlv_0_y_or;
  assign cDeIntlv_0_y_ff           = ~s1To2Sel_20b_x_ir;

  assign s1To2And_20_x             = s1To2Sel_20b_y0;
  assign s1To2And_20_x_fe          = ~s1To2Sel_20b_y0_or;
  assign s1To2Sel_20b_y0_ff        = ~s1To2And_20_x_ir;

  assign s2To1Ilv_20_x1            = s1To2Sel_20b_y1;
  assign s2To1Ilv_20_x1_fe         = ~s1To2Sel_20b_y1_or;
  assign s1To2Sel_20b_y1_ff        = ~s2To1Ilv_20_x1_ir;

  assign memReplay_52x20_x         = s1To2And_20_y0;
  assign memReplay_52x20_x_fe      = ~s1To2And_20_y0_or;
  assign s1To2And_20_y0_ff         = ~memReplay_52x20_x_ir;

  assign s4To1Sel_20_x0            = s1To2And_20_y1;
  assign s4To1Sel_20_x0_fe         = ~s1To2And_20_y1_or;
  assign s1To2And_20_y1_ff         = ~s4To1Sel_20_x0_ir;

  assign s2To1Ilv_20_x0            = memReplay_52x20_y;
  assign s2To1Ilv_20_x0_fe         = ~memReplay_52x20_y_or;
  assign memReplay_52x20_y_ff      = ~s2To1Ilv_20_x0_ir;

  assign s4To1Sel_20_x3            = s2To1Ilv_20_y;
  assign s4To1Sel_20_x3_fe         = ~s2To1Ilv_20_y_or;
  assign s2To1Ilv_20_y_ff          = ~s4To1Sel_20_x3_ir;

  assign buf2_20_x                 = s4To1Sel_20_y;
  assign buf2_20_x_fe              = ~s4To1Sel_20_y_or;
  assign s4To1Sel_20_y_ff          = ~buf2_20_x_ir;

  assign cxMulAvg_0_x              = buf2_20_y;
  assign cxMulAvg_0_x_fe           = ~buf2_20_y_or;
  assign buf2_20_y_ff              = ~cxMulAvg_0_x_ir;

  assign pltDel_0_x                = cxMulAvg_0_ySh;
  assign pltDel_0_x_fe             = ~cxMulAvg_0_ySh_or;
  assign cxMulAvg_0_ySh_ff         = ~pltDel_0_x_ir;

  assign yC                        = cxMulAvg_0_yC;
  assign yC_or                     = cxMulAvg_0_yC_or;
  assign cxMulAvg_0_yC_ff          = yC_ff;

  assign ySh                       = pltDel_0_y;
  assign ySh_or                    = pltDel_0_y_or;
  assign pltDel_0_y_ff             = ySh_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | lsCcf_0_regWe | wnrFilt_0_regWe | cxMulAvg_0_regWe
                      | cDeIntlv_0_regWe | pltDel_0_regWe | memReplay_52x20_regWe
                      | s1To2Sel_20a_regWe | s1To2Sel_20b_regWe | s1To2Sel_20c_regWe
                      | s2To1Sel_20_regWe | s1To2And_20_regWe | s4To1Sel_20_regWe
                      | s2To1Ilv_20_regWe | buf2_20_regWe;
  assign regReOut = 0 | lsCcf_0_regRe | wnrFilt_0_regRe | cxMulAvg_0_regRe
                      | cDeIntlv_0_regRe | pltDel_0_regRe | memReplay_52x20_regRe
                      | s1To2Sel_20a_regRe | s1To2Sel_20b_regRe | s1To2Sel_20c_regRe
                      | s2To1Sel_20_regRe | s1To2And_20_regRe | s4To1Sel_20_regRe
                      | s2To1Ilv_20_regRe | buf2_20_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  wire [wu-1:0] xuRe, xuIm, xuLimRe, xuLimIm;

  // --------------------------------------------------------------------------------------
  // Connect control lines
  assign  lsCcf_0_run1          = run1_q;
  assign  cxMulAvg_0_run1       = run1_q;
  assign  wnrFilt_0_run1        = run1_q==modeChEst;
  assign  cDeIntlv_0_run1       = (run1_q==modeChEst) | (run1_q==modeChCor);
  assign  pltDel_0_run1         = run1_q==modeChEst;
  assign  s2To1Ilv_20_run1      = run1_q==modeChCor;
  assign  memReplay_52x20_run1  = (run1_q==0)         ? 0 :
                                  (run1_q==modeChEst) ? 2 :
                                                        3 ;
  
  // Connect input x -> switch s1To2 (or dump for AmpEst)
  assign s1To2Sel_20a_x    = x;
  assign s1To2Sel_20a_x_fe = x_fe;
  assign x_ir              = s1To2Sel_20a_x_ir | run1_q==modeAmpEst;

  // Connect input xu -> input 2 of switch 4->1, limit to -255
  assign xuRe     = xu[wu-1:0];
  assign xuIm     = xu[2*wu-1:wu];
  assign xuLimRe  = xuRe==2**(wu-1) ? -(2**(wu-1)-1) : xuRe;
  assign xuLimIm  = xuIm==2**(wu-1) ? -(2**(wu-1)-1) : xuIm;

  assign s4To1Sel_20_x2     = {xuLimIm, xuLimRe};
  assign s4To1Sel_20_x2_fe  = xu_fe;
  assign xu_ir              = run1_q!=0;
    
  // Assign switching lines for s1To2Sel_20a/b/c, s2To1Sel_20, s4To1Sel_20
  assign s1To2Sel_20a_sel = (run1_q==modeFte   | 
                             run1_q==modeChEst | 
                             run1_q==modeChCor)  ? 0 : 1;
                                                  
  assign s1To2Sel_20b_sel = (run1_q==modeChEst) ? 0 : 1;
  assign s1To2Sel_20c_sel = (run1_q==modeChEst) ? 0 : 1;
  assign s2To1Sel_20_sel  = (run1_q==modeChEst) ? 0 : 1;
  
  assign s4To1Sel_20_sel  = (run1_q==modeChEst)  ? 0 :
                            (run1_q==modeFfe)    ? 1 :
                            (run1_q==modeAmpEst) ? 2 :
                                                   3 ;

  // Connect IRQ lines
  assign  irqDone[WlanIrqBitRxFteDone_C      - WlanIrqBitRxFteDone_C] = lsCcf_0_irqFteDone;
  assign  irqDone[WlanIrqBitRxCxMulAvgDone_C - WlanIrqBitRxFteDone_C] = cxMulAvg_0_irqDone;
  
  assign  buf2_20_run1 = run1_q!=0;
  
endmodule
//=========================================================================================

