//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssNorm
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssNorm(y, y_or, y_ff, y_we, 
              yAmp, yAmp_or, yAmp_ff, yAmp_we, 
              x, x_ir, x_fe, x_re, 
              run1, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter yAmp_w            = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter wa                = 0;

  parameter ffIn_w            = 0;
  parameter ffIn_n            = 0;
  parameter ffIn_m            = 0;
  parameter R_ffIn            = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  output         [yAmp_w-1:0]  yAmp;
  output                       yAmp_or;
  input                        yAmp_ff;
  output                       yAmp_we;
  assign                       yAmp_we = yAmp_or & ~yAmp_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Included instances
  `include "ssAvg_0.v"
  `include "ssDiv_0.v"
  `include "s1To2And_20.v"
  `include "s1To2And_9.v"
  `include "cutN_20c4.v"

  // --------------------------------------------------------------------------------------
  // Define FIFO connections

  // ----------------------------------------
  // Fifo s1To2And_20_y0 -> cutN_20c4_x
  wire         [ffIn_w-1:0]  ffIn_q;
  wire                       ffIn_fe;
  wire                       ffIn_ff;
  wire                       ffIn_ff2;
  wire                       ffIn_fuf;
  wire                       ffIn_fof;
  wire         [ffIn_w-1:0]  ffIn_d;
  wire                       ffIn_re;
  wire                       ffIn_we;
  wire                       ffIn_ir;
  wire                       ffIn_or;
  wire                       ffIn_rst;

  fifoB ffIn(ffIn_q, ffIn_fe, ffIn_ff, ffIn_ff2, ffIn_fuf,
             ffIn_fof, ffIn_d, ffIn_re, ffIn_we, ffIn_ir,
             ffIn_or, ffIn_rst, clk);
  defparam ffIn.w = ffIn_w;
  defparam ffIn.m = ffIn_m;
  defparam ffIn.n = ffIn_n;
  defparam ffIn.a = R_ffIn;

  assign ffIn_d                    = s1To2And_20_y0;
  assign ffIn_we                   = s1To2And_20_y0_we;
  assign s1To2And_20_y0_ff         = ffIn_ff;
  assign ffIn_or                   = s1To2And_20_y0_or;

  assign cutN_20c4_x               = ffIn_q;
  assign cutN_20c4_x_fe            = ffIn_fe;
  assign ffIn_re                   = cutN_20c4_x_re;
  assign ffIn_ir                   = cutN_20c4_x_ir;


  // --------------------------------------------------------------------------------------
  // Define connections
  assign s1To2And_20_x             = x;
  assign s1To2And_20_x_fe          = x_fe;
  assign x_ir                      = s1To2And_20_x_ir;

  assign ssAvg_0_x                 = s1To2And_20_y1;
  assign ssAvg_0_x_fe              = ~s1To2And_20_y1_or;
  assign s1To2And_20_y1_ff         = ~ssAvg_0_x_ir;

  assign s1To2And_9_x              = ssAvg_0_y;
  assign s1To2And_9_x_fe           = ~ssAvg_0_y_or;
  assign ssAvg_0_y_ff              = ~s1To2And_9_x_ir;

  assign ssDiv_0_amp               = s1To2And_9_y0;
  assign ssDiv_0_amp_fe            = ~s1To2And_9_y0_or;
  assign s1To2And_9_y0_ff          = ~ssDiv_0_amp_ir;

  assign ssDiv_0_x                 = cutN_20c4_y;
  assign ssDiv_0_x_fe              = ~cutN_20c4_y_or;
  assign cutN_20c4_y_ff            = ~ssDiv_0_x_ir;

  assign y                         = ssDiv_0_y;
  assign y_or                      = ssDiv_0_y_or;
  assign ssDiv_0_y_ff              = y_ff;

  assign yAmp                      = s1To2And_9_y1;
  assign yAmp_or                   = s1To2And_9_y1_or;
  assign s1To2And_9_y1_ff          = yAmp_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | ssAvg_0_regWe | ssDiv_0_regWe | s1To2And_20_regWe
                      | s1To2And_9_regWe | cutN_20c4_regWe;
  assign regReOut = 0 | ssAvg_0_regRe | ssDiv_0_regRe | s1To2And_20_regRe
                      | s1To2And_9_regRe | cutN_20c4_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Control connections
  assign  cutN_20c4_run1  = run1;
  assign  ssAvg_0_run1    = run1;
  assign  ssDiv_0_run1    = run1;
  
  assign  ffIn_rst        = run1==0;

endmodule
//=========================================================================================

