//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   ssCcfAvgDet
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module ssCcfAvgDet(y2, y2_or, y2_ff, y2_we, 
                   y3, y3_or, y3_ff, y3_we, 
                   y4, y4_or, y4_ff, y4_we, 
                   x, x_ir, x_fe, x_re, 
                   run1, 
                   regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y2_w              = 0;
  parameter y3_w              = 0;
  parameter y4_w              = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter thr2_w            = 0;
  parameter thr2_r            = 0;
  parameter thr2_s            = 0;
  parameter R_thr2            = 0;
  parameter thr3_w            = 0;
  parameter thr3_r            = 0;
  parameter thr3_s            = 0;
  parameter R_thr3            = 0;
  parameter thr4_w            = 0;
  parameter thr4_r            = 0;
  parameter thr4_s            = 0;
  parameter R_thr4            = 0;

  parameter wx                = 0;
  parameter wy                = 0;

  parameter xD_w              = 0;
  parameter xD_n              = 0;
  parameter xD_m              = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output           [y2_w-1:0]  y2;
  output                       y2_or;
  input                        y2_ff;
  output                       y2_we;
  assign                       y2_we = y2_or & ~y2_ff;

  output           [y3_w-1:0]  y3;
  output                       y3_or;
  input                        y3_ff;
  output                       y3_we;
  assign                       y3_we = y3_or & ~y3_ff;

  output           [y4_w-1:0]  y4;
  output                       y4_or;
  input                        y4_ff;
  output                       y4_we;
  assign                       y4_we = y4_or & ~y4_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [thr2_w-1:0]  thr2_q;
  wire           [thr2_w-1:0]  thr2_d;
  wire                         thr2_weint;
  assign                       thr2_weint = 0;

  wire           [thr3_w-1:0]  thr3_q;
  wire           [thr3_w-1:0]  thr3_d;
  wire                         thr3_weint;
  assign                       thr3_weint = 0;

  wire           [thr4_w-1:0]  thr4_q;
  wire           [thr4_w-1:0]  thr4_d;
  wire                         thr4_weint;
  assign                       thr4_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg thr2(thr2_q, regBus, thr2_d, thr2_weint, regWe, regRe, clk, reset);
  defparam thr2.w    = thr2_w;
  defparam thr2.rval = thr2_r;
  defparam thr2.sgn  = thr2_s;
  defparam thr2.adr  = R_thr2;

  ereg thr3(thr3_q, regBus, thr3_d, thr3_weint, regWe, regRe, clk, reset);
  defparam thr3.w    = thr3_w;
  defparam thr3.rval = thr3_r;
  defparam thr3.sgn  = thr3_s;
  defparam thr3.adr  = R_thr3;

  ereg thr4(thr4_q, regBus, thr4_d, thr4_weint, regWe, regRe, clk, reset);
  defparam thr4.w    = thr4_w;
  defparam thr4.rval = thr4_r;
  defparam thr4.sgn  = thr4_s;
  defparam thr4.adr  = R_thr4;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [xD_w-1:0]  xD[xD_n-1:0];

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg               xReD, xReDD;
  reg     [wy-1:0]  y2R, y3R, y4R;
  wire    [wy-1:0]  y2Nxt, y3Nxt, y4Nxt;
  wire    [wy-1:0]  add2In0, add2In1, add3In0, add3In1, add4In0, add4In1;

  integer k;
  
  // --------------------------------------------------------------------------------------
  // Assign input enable
  assign x_ir  = run1 & xReD==0;
  
  // Add for XST compatibility
  wire    [xD_w-1:0] xD0, xD32, xD64;
  assign  xD0  = xD[0];
  assign  xD32 = xD[32];
  assign  xD64 = xD[64];
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  assign add2In0 = x_re ? {3'b000, x}     : y2R;
  assign add2In1 = x_re ? {3'b000, xD64}  : thr2_q;
  assign add3In0 = x_re ? y2Nxt           : y3R;
  assign add3In1 = x_re ? {3'b000, xD32}  : thr3_q;
  assign add4In0 = x_re ? y3Nxt           : y4R;
  assign add4In1 = x_re ? {3'b000, xD0}   : thr4_q;

  // Add up
  assign y2Nxt = add2In0 + add2In1;
  assign y3Nxt = add3In0 + add3In1;
  assign y4Nxt = add4In0 + add4In1;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    // Reset
    if (run1==0) begin

      for (k=0; k<xD_n; k=k+1) begin
        xD[k] <= 0;
      end
      xReD     <= 0;
      xReDD    <= 0;
      
    // Normal operation
    end else begin
      
      // Register update
      if (x_re) begin
        for (k=0; k<xD_n-1; k=k+1) begin
          xD[k] <= xD[k+1];
        end
        xD[xD_n-1] <= x;
      end
      
      // Update adders
      y2R <= y2Nxt;
      y3R <= y3Nxt;
      y4R <= y4Nxt;
    
      // Update delayed handshake lines
      xReD        <= x_re;
      xReDD       <= xReD;
            
    end // if (run1==0) ... else
  end // always

  // Assign output
  assign y2     = y2R;
  assign y2_or  = xReDD;
  assign y3     = y3R;
  assign y3_or  = xReDD;
  assign y4     = y4R;
  assign y4_or  = xReDD;

endmodule
//=========================================================================================

