//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ssAvg_0_x_w             = 20;

  // Outputs
  parameter ssAvg_0_y_w             = 9;

  // Input control lines
  parameter ssAvg_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter ssAvg_0_wx              = 10;
  parameter ssAvg_0_wy              = 9;
  parameter ssAvg_0_sh              = 5;

  // Iregs
  parameter ssAvg_0_xSumD_w         = 9;
  parameter ssAvg_0_xSumD_n         = 1;
  parameter ssAvg_0_xSumD_m         = `CLOG2(1);
  parameter ssAvg_0_cntSmplOut_w    = 1;
  parameter ssAvg_0_cntSmplOut_n    = 1;
  parameter ssAvg_0_cntSmplOut_m    = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ssAvg_0.x_w             = ssAvg_0_x_w;
  defparam ssAvg_0.y_w             = ssAvg_0_y_w;
  defparam ssAvg_0.run1_w          = ssAvg_0_run1_w;
  defparam ssAvg_0.wx              = ssAvg_0_wx;
  defparam ssAvg_0.wy              = ssAvg_0_wy;
  defparam ssAvg_0.sh              = ssAvg_0_sh;
  defparam ssAvg_0.xSumD_w         = ssAvg_0_xSumD_w;
  defparam ssAvg_0.xSumD_n         = ssAvg_0_xSumD_n;
  defparam ssAvg_0.xSumD_m         = ssAvg_0_xSumD_m;
  defparam ssAvg_0.cntSmplOut_w    = ssAvg_0_cntSmplOut_w;
  defparam ssAvg_0.cntSmplOut_n    = ssAvg_0_cntSmplOut_n;
  defparam ssAvg_0.cntSmplOut_m    = ssAvg_0_cntSmplOut_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [ssAvg_0_y_w-1:0]  ssAvg_0_y;
  wire                                      ssAvg_0_y_or;
  wire                                      ssAvg_0_y_ff;
  wire                                      ssAvg_0_y_we;

  wire                   [ssAvg_0_x_w-1:0]  ssAvg_0_x;
  wire                                      ssAvg_0_x_ir;
  wire                                      ssAvg_0_x_fe;
  wire                                      ssAvg_0_x_re;

  wire                [ssAvg_0_run1_w-1:0]  ssAvg_0_run1;

  wire                                      ssAvg_0_regWe;
  wire                                      ssAvg_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ssAvg ssAvg_0(ssAvg_0_y, ssAvg_0_y_or, ssAvg_0_y_ff, ssAvg_0_y_we,
                ssAvg_0_x, ssAvg_0_x_ir, ssAvg_0_x_fe, ssAvg_0_x_re, 
                ssAvg_0_run1, 
                regBus, regWe, regRe, ssAvg_0_regWe, ssAvg_0_regRe, clk, clk2, reset);


//==============================================================================
