//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter src11to20_0_x11_w           = 4;

  // Outputs
  parameter src11to20_0_x20_w           = 12;

  // Input control lines
  parameter src11to20_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter src11to20_0_w               = 6;
  parameter src11to20_0_ldPatInit       = 709978;

  // Iregs
  parameter src11to20_0_x11Re_w         = 2;
  parameter src11to20_0_x11Re_n         = 3;
  parameter src11to20_0_x11Re_m         = `CLOG2(3);
  parameter src11to20_0_x11Im_w         = 2;
  parameter src11to20_0_x11Im_n         = 3;
  parameter src11to20_0_x11Im_m         = `CLOG2(3);
  parameter src11to20_0_sumX11Re_w      = 6;
  parameter src11to20_0_sumX11Re_n      = 1;
  parameter src11to20_0_sumX11Re_m      = `CLOG2(1);
  parameter src11to20_0_sumX11Im_w      = 6;
  parameter src11to20_0_sumX11Im_n      = 1;
  parameter src11to20_0_sumX11Im_m      = `CLOG2(1);
  parameter src11to20_0_cnt_w           = 6;
  parameter src11to20_0_cnt_n           = 1;
  parameter src11to20_0_cnt_m           = `CLOG2(1);
  parameter src11to20_0_ldPat_w         = 20;
  parameter src11to20_0_ldPat_n         = 1;
  parameter src11to20_0_ldPat_m         = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam src11to20_0.x11_w           = src11to20_0_x11_w;
  defparam src11to20_0.x20_w           = src11to20_0_x20_w;
  defparam src11to20_0.run1_w          = src11to20_0_run1_w;
  defparam src11to20_0.w               = src11to20_0_w;
  defparam src11to20_0.ldPatInit       = src11to20_0_ldPatInit;
  defparam src11to20_0.x11Re_w         = src11to20_0_x11Re_w;
  defparam src11to20_0.x11Re_n         = src11to20_0_x11Re_n;
  defparam src11to20_0.x11Re_m         = src11to20_0_x11Re_m;
  defparam src11to20_0.x11Im_w         = src11to20_0_x11Im_w;
  defparam src11to20_0.x11Im_n         = src11to20_0_x11Im_n;
  defparam src11to20_0.x11Im_m         = src11to20_0_x11Im_m;
  defparam src11to20_0.sumX11Re_w      = src11to20_0_sumX11Re_w;
  defparam src11to20_0.sumX11Re_n      = src11to20_0_sumX11Re_n;
  defparam src11to20_0.sumX11Re_m      = src11to20_0_sumX11Re_m;
  defparam src11to20_0.sumX11Im_w      = src11to20_0_sumX11Im_w;
  defparam src11to20_0.sumX11Im_n      = src11to20_0_sumX11Im_n;
  defparam src11to20_0.sumX11Im_m      = src11to20_0_sumX11Im_m;
  defparam src11to20_0.cnt_w           = src11to20_0_cnt_w;
  defparam src11to20_0.cnt_n           = src11to20_0_cnt_n;
  defparam src11to20_0.cnt_m           = src11to20_0_cnt_m;
  defparam src11to20_0.ldPat_w         = src11to20_0_ldPat_w;
  defparam src11to20_0.ldPat_n         = src11to20_0_ldPat_n;
  defparam src11to20_0.ldPat_m         = src11to20_0_ldPat_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_src11to20_0_lut_cf11bTx_wrAdr                              = 0;
  defparam  src11to20_0.R_lut_cf11bTx_wrAdr                              = R_src11to20_0_lut_cf11bTx_wrAdr;
  parameter R_src11to20_0_lut_cf11bTx_wrDatHi                            = 1;
  defparam  src11to20_0.R_lut_cf11bTx_wrDatHi                            = R_src11to20_0_lut_cf11bTx_wrDatHi;
  parameter R_src11to20_0_lut_cf11bTx_wrDatLo                            = 2;
  defparam  src11to20_0.R_lut_cf11bTx_wrDatLo                            = R_src11to20_0_lut_cf11bTx_wrDatLo;
  parameter R_src11to20_0_lut_cf11bTx_simInit                            = 3;
  defparam  src11to20_0.R_lut_cf11bTx_simInit                            = R_src11to20_0_lut_cf11bTx_simInit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire             [src11to20_0_x20_w-1:0]  src11to20_0_x20;
  wire                                      src11to20_0_x20_or;
  wire                                      src11to20_0_x20_ff;
  wire                                      src11to20_0_x20_we;

  wire             [src11to20_0_x11_w-1:0]  src11to20_0_x11;
  wire                                      src11to20_0_x11_ir;
  wire                                      src11to20_0_x11_fe;
  wire                                      src11to20_0_x11_re;

  wire            [src11to20_0_run1_w-1:0]  src11to20_0_run1;

  wire                                      src11to20_0_regWe;
  wire                                      src11to20_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  src11to20 src11to20_0(src11to20_0_x20, src11to20_0_x20_or, src11to20_0_x20_ff, src11to20_0_x20_we,
                        src11to20_0_x11, src11to20_0_x11_ir, src11to20_0_x11_fe, src11to20_0_x11_re, 
                        src11to20_0_run1, 
                        regBus, regWe, regRe, src11to20_0_regWe, src11to20_0_regRe, clk, clk2, reset);


//==============================================================================
