//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter shortSym_0_x_w             = 20;

  // Outputs
  parameter shortSym_0_y_w             = 20;

  // Input control lines
  parameter shortSym_0_run1_w          = 1;

  // Output control lines
  parameter shortSym_0_irqPsduDone_w   = 1;

  // Eregs
  parameter shortSym_0_numOfdm_w       = 11;
  parameter shortSym_0_numOfdm_r       = 0;
  parameter shortSym_0_numOfdm_s       = 0;

  // Parameters
  parameter shortSym_0_w               = 10;
  parameter shortSym_0_ssTime0         = 68675;
  parameter shortSym_0_ssTime1         = 3904;
  parameter shortSym_0_ssTime2         = 932844;
  parameter shortSym_0_ssTime3         = 1030351;
  parameter shortSym_0_ssTime4         = 134;

  // Iregs
  parameter shortSym_0_mode1_w         = 2;
  parameter shortSym_0_mode1_n         = 1;
  parameter shortSym_0_mode1_m         = `CLOG2(1);
  parameter shortSym_0_cntOfdm_w       = 11;
  parameter shortSym_0_cntOfdm_n       = 1;
  parameter shortSym_0_cntOfdm_m       = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam shortSym_0.x_w             = shortSym_0_x_w;
  defparam shortSym_0.y_w             = shortSym_0_y_w;
  defparam shortSym_0.run1_w          = shortSym_0_run1_w;
  defparam shortSym_0.irqPsduDone_w   = shortSym_0_irqPsduDone_w;
  defparam shortSym_0.numOfdm_w       = shortSym_0_numOfdm_w;
  defparam shortSym_0.numOfdm_r       = shortSym_0_numOfdm_r;
  defparam shortSym_0.numOfdm_s       = shortSym_0_numOfdm_s;
  defparam shortSym_0.w               = shortSym_0_w;
  defparam shortSym_0.ssTime0         = shortSym_0_ssTime0;
  defparam shortSym_0.ssTime1         = shortSym_0_ssTime1;
  defparam shortSym_0.ssTime2         = shortSym_0_ssTime2;
  defparam shortSym_0.ssTime3         = shortSym_0_ssTime3;
  defparam shortSym_0.ssTime4         = shortSym_0_ssTime4;
  defparam shortSym_0.mode1_w         = shortSym_0_mode1_w;
  defparam shortSym_0.mode1_n         = shortSym_0_mode1_n;
  defparam shortSym_0.mode1_m         = shortSym_0_mode1_m;
  defparam shortSym_0.cntOfdm_w       = shortSym_0_cntOfdm_w;
  defparam shortSym_0.cntOfdm_n       = shortSym_0_cntOfdm_n;
  defparam shortSym_0.cntOfdm_m       = shortSym_0_cntOfdm_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_shortSym_0_numOfdm                                         = 0;
  defparam  shortSym_0.R_numOfdm                                         = R_shortSym_0_numOfdm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [shortSym_0_y_w-1:0]  shortSym_0_y;
  wire                                      shortSym_0_y_or;
  wire                                      shortSym_0_y_ff;
  wire                                      shortSym_0_y_we;

  wire                [shortSym_0_x_w-1:0]  shortSym_0_x;
  wire                                      shortSym_0_x_ir;
  wire                                      shortSym_0_x_fe;
  wire                                      shortSym_0_x_re;

  wire      [shortSym_0_irqPsduDone_w-1:0]  shortSym_0_irqPsduDone;

  wire             [shortSym_0_run1_w-1:0]  shortSym_0_run1;

  wire                                      shortSym_0_regWe;
  wire                                      shortSym_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  shortSym shortSym_0(shortSym_0_y, shortSym_0_y_or, shortSym_0_y_ff, shortSym_0_y_we,
                      shortSym_0_x, shortSym_0_x_ir, shortSym_0_x_fe, shortSym_0_x_re, 
                      shortSym_0_irqPsduDone, 
                      shortSym_0_run1, 
                      regBus, regWe, regRe, shortSym_0_regWe, shortSym_0_regRe, clk, clk2, reset);


//==============================================================================
