//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter scrmbl_tx11b_xs_w            = 2;

  // Outputs
  parameter scrmbl_tx11b_y_w             = 1;

  // Input control lines
  parameter scrmbl_tx11b_run1_w          = 1;
  parameter scrmbl_tx11b_scrMode_w       = 2;

  // Output control lines

  // Eregs
  parameter scrmbl_tx11b_s_w             = 7;
  parameter scrmbl_tx11b_s_r             = 0;
  parameter scrmbl_tx11b_s_s             = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam scrmbl_tx11b.xs_w            = scrmbl_tx11b_xs_w;
  defparam scrmbl_tx11b.y_w             = scrmbl_tx11b_y_w;
  defparam scrmbl_tx11b.run1_w          = scrmbl_tx11b_run1_w;
  defparam scrmbl_tx11b.scrMode_w       = scrmbl_tx11b_scrMode_w;
  defparam scrmbl_tx11b.s_w             = scrmbl_tx11b_s_w;
  defparam scrmbl_tx11b.s_r             = scrmbl_tx11b_s_r;
  defparam scrmbl_tx11b.s_s             = scrmbl_tx11b_s_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_scrmbl_tx11b_s                                             = 0;
  defparam  scrmbl_tx11b.R_s                                             = R_scrmbl_tx11b_s;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire              [scrmbl_tx11b_y_w-1:0]  scrmbl_tx11b_y;
  wire                                      scrmbl_tx11b_y_or;
  wire                                      scrmbl_tx11b_y_ff;
  wire                                      scrmbl_tx11b_y_we;

  wire             [scrmbl_tx11b_xs_w-1:0]  scrmbl_tx11b_xs;
  wire                                      scrmbl_tx11b_xs_ir;
  wire                                      scrmbl_tx11b_xs_fe;
  wire                                      scrmbl_tx11b_xs_re;

  wire           [scrmbl_tx11b_run1_w-1:0]  scrmbl_tx11b_run1;
  wire        [scrmbl_tx11b_scrMode_w-1:0]  scrmbl_tx11b_scrMode;

  wire                                      scrmbl_tx11b_regWe;
  wire                                      scrmbl_tx11b_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  scrmbl scrmbl_tx11b(scrmbl_tx11b_y, scrmbl_tx11b_y_or, scrmbl_tx11b_y_ff, scrmbl_tx11b_y_we,
                      scrmbl_tx11b_xs, scrmbl_tx11b_xs_ir, scrmbl_tx11b_xs_fe, scrmbl_tx11b_xs_re, 
                      scrmbl_tx11b_run1, 
                      scrmbl_tx11b_scrMode, 
                      regBus, regWe, regRe, scrmbl_tx11b_regWe, scrmbl_tx11b_regRe, clk, clk2, reset);


//==============================================================================
