//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter scrmbl_0_xs_w            = 2;

  // Outputs
  parameter scrmbl_0_y_w             = 1;

  // Input control lines
  parameter scrmbl_0_run1_w          = 1;
  parameter scrmbl_0_scrMode_w       = 2;

  // Output control lines

  // Eregs
  parameter scrmbl_0_s_w             = 7;
  parameter scrmbl_0_s_r             = 0;
  parameter scrmbl_0_s_s             = 0;

  // Parameters

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam scrmbl_0.xs_w            = scrmbl_0_xs_w;
  defparam scrmbl_0.y_w             = scrmbl_0_y_w;
  defparam scrmbl_0.run1_w          = scrmbl_0_run1_w;
  defparam scrmbl_0.scrMode_w       = scrmbl_0_scrMode_w;
  defparam scrmbl_0.s_w             = scrmbl_0_s_w;
  defparam scrmbl_0.s_r             = scrmbl_0_s_r;
  defparam scrmbl_0.s_s             = scrmbl_0_s_s;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_scrmbl_0_s                                                 = 0;
  defparam  scrmbl_0.R_s                                                 = R_scrmbl_0_s;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [scrmbl_0_y_w-1:0]  scrmbl_0_y;
  wire                                      scrmbl_0_y_or;
  wire                                      scrmbl_0_y_ff;
  wire                                      scrmbl_0_y_we;

  wire                 [scrmbl_0_xs_w-1:0]  scrmbl_0_xs;
  wire                                      scrmbl_0_xs_ir;
  wire                                      scrmbl_0_xs_fe;
  wire                                      scrmbl_0_xs_re;

  wire               [scrmbl_0_run1_w-1:0]  scrmbl_0_run1;
  wire            [scrmbl_0_scrMode_w-1:0]  scrmbl_0_scrMode;

  wire                                      scrmbl_0_regWe;
  wire                                      scrmbl_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  scrmbl scrmbl_0(scrmbl_0_y, scrmbl_0_y_or, scrmbl_0_y_ff, scrmbl_0_y_we,
                  scrmbl_0_xs, scrmbl_0_xs_ir, scrmbl_0_xs_fe, scrmbl_0_xs_re, 
                  scrmbl_0_run1, 
                  scrmbl_0_scrMode, 
                  regBus, regWe, regRe, scrmbl_0_regWe, scrmbl_0_regRe, clk, clk2, reset);


//==============================================================================
