//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   scrmbl
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module scrmbl(y, y_or, y_ff, y_we, 
              xs, xs_ir, xs_fe, xs_re, 
              run1, 
              scrMode, 
              regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter xs_w              = 0;

  parameter run1_w            = 0;
  parameter scrMode_w         = 0;

  parameter s_w               = 0;
  parameter s_r               = 0;
  parameter s_s               = 0;
  parameter R_s               = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input            [xs_w-1:0]  xs;
  output                       xs_ir;
  input                        xs_fe;
  output                       xs_re;
  assign                       xs_re = xs_ir & ~xs_fe;

  input          [run1_w-1:0]  run1;
  input       [scrMode_w-1:0]  scrMode;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire              [s_w-1:0]  s_q;
  wire              [s_w-1:0]  s_d;
  wire                         s_weint;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg s(s_q, regBus, s_d, s_weint, regWe, regRe, clk, reset);
  defparam s.w    = s_w;
  defparam s.rval = s_r;
  defparam s.sgn  = s_s;
  defparam s.adr  = R_s;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "buf2_1.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign y                         = buf2_1_y;
  assign y_or                      = buf2_1_y_or;
  assign buf2_1_y_ff               = y_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | buf2_1_regWe;
  assign regReOut = 0 | buf2_1_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg          [s_w-1:0]  s_nxt;
  reg          [y_w-1:0]  yOut;   
  reg                     b;
  
  wire         [y_w-1:0]  yP;                   // Preliminary output
  wire                    yP_we, yP_or, yP_ff;  // before buffering

  // --------------------------------------------------------------------------------------
  // Copy this autogenerated stuff to avoid non-causal use of yP
  assign buf2_1_x                  = yP;
  assign buf2_1_x_fe               = ~yP_or;
  assign yP_ff                     = ~buf2_1_x_ir;

  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign xs_ir = run1 & yP_ff==0;  
  assign yP_or = run1 & xs_fe==0;
  assign yP_we = yP_or & ~yP_ff;
  assign yP    = yOut;
  
  // Output buffer control
  assign buf2_1_run1 = run1;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  always @(*) begin
        
    b    = s_q[3] ^ s_q[6];
    yOut = xs[1] ? b^xs[0] : xs[0];
    
    s_nxt[6:1] = s_q[5:0];          // shift left

    case (scrMode) 
      2'b00 : s_nxt[0] = b;         // 11a
      2'b01 : s_nxt[0] = yOut;      // 11b enc
      2'b10 : s_nxt[0] = xs[0];     // 11b dec
      2'b11 : s_nxt[0] = 1'bx;      // don't care
    endcase    

  end

  // --------------------------------------------------------------------------------------
  // Scrambler feedback
  assign s_d     = s_nxt;
  assign s_weint = yP_we & xs[1];
    
endmodule
//=========================================================================================

