//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter scaleTx_0_x_w             = 20;

  // Outputs
  parameter scaleTx_0_y_w             = 24;

  // Input control lines
  parameter scaleTx_0_run1_w          = 1;

  // Output control lines

  // Eregs
  parameter scaleTx_0_scFac_w         = 16;
  parameter scaleTx_0_scFac_r         = 8192;
  parameter scaleTx_0_scFac_s         = 0;

  // Parameters
  parameter scaleTx_0_wx              = 10;
  parameter scaleTx_0_wy              = 12;
  parameter scaleTx_0_ws              = 16;
  parameter scaleTx_0_bs              = 11;

  // Iregs
  parameter scaleTx_0_yR_w            = 24;
  parameter scaleTx_0_yR_n            = 1;
  parameter scaleTx_0_yR_m            = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam scaleTx_0.x_w             = scaleTx_0_x_w;
  defparam scaleTx_0.y_w             = scaleTx_0_y_w;
  defparam scaleTx_0.run1_w          = scaleTx_0_run1_w;
  defparam scaleTx_0.scFac_w         = scaleTx_0_scFac_w;
  defparam scaleTx_0.scFac_r         = scaleTx_0_scFac_r;
  defparam scaleTx_0.scFac_s         = scaleTx_0_scFac_s;
  defparam scaleTx_0.wx              = scaleTx_0_wx;
  defparam scaleTx_0.wy              = scaleTx_0_wy;
  defparam scaleTx_0.ws              = scaleTx_0_ws;
  defparam scaleTx_0.bs              = scaleTx_0_bs;
  defparam scaleTx_0.yR_w            = scaleTx_0_yR_w;
  defparam scaleTx_0.yR_n            = scaleTx_0_yR_n;
  defparam scaleTx_0.yR_m            = scaleTx_0_yR_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_scaleTx_0_scFac                                            = 0;
  defparam  scaleTx_0.R_scFac                                            = R_scaleTx_0_scFac;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [scaleTx_0_y_w-1:0]  scaleTx_0_y;
  wire                                      scaleTx_0_y_or;
  wire                                      scaleTx_0_y_ff;
  wire                                      scaleTx_0_y_we;

  wire                 [scaleTx_0_x_w-1:0]  scaleTx_0_x;
  wire                                      scaleTx_0_x_ir;
  wire                                      scaleTx_0_x_fe;
  wire                                      scaleTx_0_x_re;

  wire              [scaleTx_0_run1_w-1:0]  scaleTx_0_run1;

  wire                                      scaleTx_0_regWe;
  wire                                      scaleTx_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  scaleTx scaleTx_0(scaleTx_0_y, scaleTx_0_y_or, scaleTx_0_y_ff, scaleTx_0_y_we,
                    scaleTx_0_x, scaleTx_0_x_ir, scaleTx_0_x_fe, scaleTx_0_x_re, 
                    scaleTx_0_run1, 
                    regBus, regWe, regRe, scaleTx_0_regWe, scaleTx_0_regRe, clk, clk2, reset);


//==============================================================================
