//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   scaleTx
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module scaleTx(y, y_or, y_ff, y_we, 
               x, x_ir, x_fe, x_re, 
               run1, 
               regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x_w               = 0;

  parameter run1_w            = 0;

  parameter scFac_w           = 0;
  parameter scFac_r           = 0;
  parameter scFac_s           = 0;
  parameter R_scFac           = 0;

  parameter wx                = 0;
  parameter wy                = 0;
  parameter ws                = 0;
  parameter bs                = 0;

  parameter yR_w              = 0;
  parameter yR_n              = 0;
  parameter yR_m              = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input             [x_w-1:0]  x;
  output                       x_ir;
  input                        x_fe;
  output                       x_re;
  assign                       x_re = x_ir & ~x_fe;

  input          [run1_w-1:0]  run1;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire          [scFac_w-1:0]  scFac_q;
  wire          [scFac_w-1:0]  scFac_d;
  wire                         scFac_weint;
  assign                       scFac_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg scFac(scFac_q, regBus, scFac_d, scFac_weint, regWe, regRe, clk, reset);
  defparam scFac.w    = scFac_w;
  defparam scFac.rval = scFac_r;
  defparam scFac.sgn  = scFac_s;
  defparam scFac.adr  = R_scFac;

  // --------------------------------------------------------------------------------------
  // Internal status registers
  reg              [yR_w-1:0]  yR;

  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Register definitions
  reg                   state;
  wire        [wx-1:0]  xRe, xIm;
  reg         [wx-1:0]  xImBuf;
  wire        [wx-1:0]  xMulIn;
  wire     [wx+ws-2:0]  yMul;
  wire        [wy-1:0]  ySat;
  
  // --------------------------------------------------------------------------------------
  // Assign input and output enable
  assign x_ir = run1 & y_we;
  assign y_or = run1 & state==0;
  
  // --------------------------------------------------------------------------------------
  // Signal processing behaviour
  assign xRe    = x[  wx-1: 0];
  assign xIm    = x[2*wx-1:wx];
  assign xMulIn = (state==0) ? xRe : xImBuf;

  // Multiply y = x*scFac
  mulSi mul1(yMul, xMulIn, scFac_q);
  defparam mul1.c_w  = wx+ws-1;
  defparam mul1.a_w  = wx;
  defparam mul1.b_w  = ws;
  
  // Saturation of multiplier output
  sat satOut(ySat, yMul[wx+ws-2:bs]);
  defparam satOut.y_w = wy;
  defparam satOut.x_w = wx+ws-1-bs;

  // --------------------------------------------------------------------------------------
  // FSM
  always @(posedge clk) begin
    
    if (run1==0) begin
      state <= 0;
      yR    <= 0;
    end else
    
    if (state==0 & y_we) begin
      state       <= 1;
      yR[wy-1:0]  <= ySat;
      xImBuf      <= xIm;
    end else
    
    if (state==1) begin
      state         <= 0;
      yR[2*wy-1:wy] <= ySat;
    end
    
  end //always @(posedge clk)
  
  // Assign output finally
  assign y = yR;
 
endmodule
//=========================================================================================

