//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter scaleRx_0_x_w             = 24;

  // Outputs
  parameter scaleRx_0_y_w             = 20;

  // Input control lines

  // Output control lines

  // Eregs

  // Parameters
  parameter scaleRx_0_wx              = 12;
  parameter scaleRx_0_wy              = 10;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam scaleRx_0.x_w             = scaleRx_0_x_w;
  defparam scaleRx_0.y_w             = scaleRx_0_y_w;
  defparam scaleRx_0.wx              = scaleRx_0_wx;
  defparam scaleRx_0.wy              = scaleRx_0_wy;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [scaleRx_0_y_w-1:0]  scaleRx_0_y;
  wire                                      scaleRx_0_y_or;
  wire                                      scaleRx_0_y_ff;
  wire                                      scaleRx_0_y_we;

  wire                 [scaleRx_0_x_w-1:0]  scaleRx_0_x;
  wire                                      scaleRx_0_x_ir;
  wire                                      scaleRx_0_x_fe;
  wire                                      scaleRx_0_x_re;

  wire                                      scaleRx_0_regWe;
  wire                                      scaleRx_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  scaleRx scaleRx_0(scaleRx_0_y, scaleRx_0_y_or, scaleRx_0_y_ff, scaleRx_0_y_we,
                    scaleRx_0_x, scaleRx_0_x_ir, scaleRx_0_x_fe, scaleRx_0_x_re, 
                    regBus, regWe, regRe, scaleRx_0_regWe, scaleRx_0_regRe, clk, clk2, reset);


//==============================================================================
