//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter sbCalc_0_x_w             = 11;
  parameter sbCalc_0_sh_w            = 9;

  // Outputs
  parameter sbCalc_0_sb_w            = 22;

  // Input control lines
  parameter sbCalc_0_run1_w          = 1;

  // Output control lines

  // Eregs

  // Parameters
  parameter sbCalc_0_wx              = 11;
  parameter sbCalc_0_ws              = 9;
  parameter sbCalc_0_wb              = 6;
  parameter sbCalc_0_wbb             = 4;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam sbCalc_0.x_w             = sbCalc_0_x_w;
  defparam sbCalc_0.sh_w            = sbCalc_0_sh_w;
  defparam sbCalc_0.sb_w            = sbCalc_0_sb_w;
  defparam sbCalc_0.run1_w          = sbCalc_0_run1_w;
  defparam sbCalc_0.wx              = sbCalc_0_wx;
  defparam sbCalc_0.ws              = sbCalc_0_ws;
  defparam sbCalc_0.wb              = sbCalc_0_wb;
  defparam sbCalc_0.wbb             = sbCalc_0_wbb;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                 [sbCalc_0_sb_w-1:0]  sbCalc_0_sb;
  wire                                      sbCalc_0_sb_or;
  wire                                      sbCalc_0_sb_ff;
  wire                                      sbCalc_0_sb_we;

  wire                  [sbCalc_0_x_w-1:0]  sbCalc_0_x;
  wire                                      sbCalc_0_x_ir;
  wire                                      sbCalc_0_x_fe;
  wire                                      sbCalc_0_x_re;

  wire                 [sbCalc_0_sh_w-1:0]  sbCalc_0_sh;
  wire                                      sbCalc_0_sh_ir;
  wire                                      sbCalc_0_sh_fe;
  wire                                      sbCalc_0_sh_re;

  wire               [sbCalc_0_run1_w-1:0]  sbCalc_0_run1;

  wire                                      sbCalc_0_regWe;
  wire                                      sbCalc_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  sbCalc sbCalc_0(sbCalc_0_sb, sbCalc_0_sb_or, sbCalc_0_sb_ff, sbCalc_0_sb_we,
                  sbCalc_0_x, sbCalc_0_x_ir, sbCalc_0_x_fe, sbCalc_0_x_re, 
                  sbCalc_0_sh, sbCalc_0_sh_ir, sbCalc_0_sh_fe, sbCalc_0_sh_re, 
                  sbCalc_0_run1, 
                  regBus, regWe, regRe, sbCalc_0_regWe, sbCalc_0_regRe, clk, clk2, reset);


//==============================================================================
