//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   s4To1Sel
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module s4To1Sel(y, y_or, y_ff, y_we, 
                x0, x0_ir, x0_fe, x0_re, 
                x1, x1_ir, x1_fe, x1_re, 
                x2, x2_ir, x2_fe, x2_re, 
                x3, x3_ir, x3_fe, x3_re, 
                sel, 
                regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter y_w               = 0;
  parameter x0_w              = 0;
  parameter x1_w              = 0;
  parameter x2_w              = 0;
  parameter x3_w              = 0;

  parameter sel_w             = 0;

  parameter w                 = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output            [y_w-1:0]  y;
  output                       y_or;
  input                        y_ff;
  output                       y_we;
  assign                       y_we = y_or & ~y_ff;

  input            [x0_w-1:0]  x0;
  output                       x0_ir;
  input                        x0_fe;
  output                       x0_re;
  assign                       x0_re = x0_ir & ~x0_fe;

  input            [x1_w-1:0]  x1;
  output                       x1_ir;
  input                        x1_fe;
  output                       x1_re;
  assign                       x1_re = x1_ir & ~x1_fe;

  input            [x2_w-1:0]  x2;
  output                       x2_ir;
  input                        x2_fe;
  output                       x2_re;
  assign                       x2_re = x2_ir & ~x2_fe;

  input            [x3_w-1:0]  x3;
  output                       x3_ir;
  input                        x3_fe;
  output                       x3_re;
  assign                       x3_re = x3_ir & ~x3_fe;

  input           [sel_w-1:0]  sel;

  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0;
  assign regReOut = 0;

// ----------------------------------------------------------------------------------------
//=========================================================================================

//-----------------------------------------------------------------------------------------
//Assing input and output controls
  assign y      = sel[1]==0 ? (sel[0]==0 ?  x0    :  x1) 
                            : (sel[0]==0 ?  x2    :  x3);
  assign y_or   = sel[1]==0 ? (sel[0]==0 ? ~x0_fe : ~x1_fe) 
                            : (sel[0]==0 ? ~x2_fe : ~x3_fe);
  assign x0_ir  = ~y_ff & sel==0;
  assign x1_ir  = ~y_ff & sel==1;
  assign x2_ir  = ~y_ff & sel==2;
  assign x3_ir  = ~y_ff & sel==3;

endmodule
//=========================================================================================

