//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter rxBuf_0_x_w             = 20;

  // Outputs
  parameter rxBuf_0_y_w             = 20;

  // Input control lines
  parameter rxBuf_0_run1_w          = 1;
  parameter rxBuf_0_runOut_w        = 2;
  parameter rxBuf_0_numOut_w        = 7;
  parameter rxBuf_0_fftWrap_w       = 4;
  parameter rxBuf_0_ssAcqHalt_w     = 1;

  // Output control lines
  parameter rxBuf_0_irqRxDatWr_w    = 1;

  // Eregs
  parameter rxBuf_0_wrAdr_w         = 9;
  parameter rxBuf_0_wrAdr_r         = 0;
  parameter rxBuf_0_wrAdr_s         = 0;
  parameter rxBuf_0_rdAdr0_w        = 9;
  parameter rxBuf_0_rdAdr0_r        = 0;
  parameter rxBuf_0_rdAdr0_s        = 0;
  parameter rxBuf_0_irqAdr_w        = 9;
  parameter rxBuf_0_irqAdr_r        = 0;
  parameter rxBuf_0_irqAdr_s        = 0;
  parameter rxBuf_0_agcDoneAdr_w    = 9;
  parameter rxBuf_0_agcDoneAdr_r    = 0;
  parameter rxBuf_0_agcDoneAdr_s    = 0;

  // Parameters
  parameter rxBuf_0_w               = 10;
  parameter rxBuf_0_wa              = 9;

  // Iregs

  // Single ported memories

  // Dual ported memories
  parameter rxBuf_0_dpm0_w          = 20;
  parameter rxBuf_0_dpm0_n          = 512;
  parameter rxBuf_0_dpm0_m          = `CLOG2(512);

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam rxBuf_0.x_w             = rxBuf_0_x_w;
  defparam rxBuf_0.y_w             = rxBuf_0_y_w;
  defparam rxBuf_0.run1_w          = rxBuf_0_run1_w;
  defparam rxBuf_0.runOut_w        = rxBuf_0_runOut_w;
  defparam rxBuf_0.numOut_w        = rxBuf_0_numOut_w;
  defparam rxBuf_0.fftWrap_w       = rxBuf_0_fftWrap_w;
  defparam rxBuf_0.ssAcqHalt_w     = rxBuf_0_ssAcqHalt_w;
  defparam rxBuf_0.irqRxDatWr_w    = rxBuf_0_irqRxDatWr_w;
  defparam rxBuf_0.wrAdr_w         = rxBuf_0_wrAdr_w;
  defparam rxBuf_0.wrAdr_r         = rxBuf_0_wrAdr_r;
  defparam rxBuf_0.wrAdr_s         = rxBuf_0_wrAdr_s;
  defparam rxBuf_0.rdAdr0_w        = rxBuf_0_rdAdr0_w;
  defparam rxBuf_0.rdAdr0_r        = rxBuf_0_rdAdr0_r;
  defparam rxBuf_0.rdAdr0_s        = rxBuf_0_rdAdr0_s;
  defparam rxBuf_0.irqAdr_w        = rxBuf_0_irqAdr_w;
  defparam rxBuf_0.irqAdr_r        = rxBuf_0_irqAdr_r;
  defparam rxBuf_0.irqAdr_s        = rxBuf_0_irqAdr_s;
  defparam rxBuf_0.agcDoneAdr_w    = rxBuf_0_agcDoneAdr_w;
  defparam rxBuf_0.agcDoneAdr_r    = rxBuf_0_agcDoneAdr_r;
  defparam rxBuf_0.agcDoneAdr_s    = rxBuf_0_agcDoneAdr_s;
  defparam rxBuf_0.w               = rxBuf_0_w;
  defparam rxBuf_0.wa              = rxBuf_0_wa;
  defparam rxBuf_0.dpm0_w          = rxBuf_0_dpm0_w;
  defparam rxBuf_0.dpm0_n          = rxBuf_0_dpm0_n;
  defparam rxBuf_0.dpm0_m          = rxBuf_0_dpm0_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_rxBuf_0_wrAdr                                              = 0;
  defparam  rxBuf_0.R_wrAdr                                              = R_rxBuf_0_wrAdr;
  parameter R_rxBuf_0_rdAdr0                                             = 1;
  defparam  rxBuf_0.R_rdAdr0                                             = R_rxBuf_0_rdAdr0;
  parameter R_rxBuf_0_irqAdr                                             = 2;
  defparam  rxBuf_0.R_irqAdr                                             = R_rxBuf_0_irqAdr;
  parameter R_rxBuf_0_agcDoneAdr                                         = 3;
  defparam  rxBuf_0.R_agcDoneAdr                                         = R_rxBuf_0_agcDoneAdr;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                   [rxBuf_0_y_w-1:0]  rxBuf_0_y;
  wire                                      rxBuf_0_y_or;
  wire                                      rxBuf_0_y_ff;
  wire                                      rxBuf_0_y_we;

  wire                   [rxBuf_0_x_w-1:0]  rxBuf_0_x;
  wire                                      rxBuf_0_x_ir;
  wire                                      rxBuf_0_x_fe;
  wire                                      rxBuf_0_x_re;

  wire          [rxBuf_0_irqRxDatWr_w-1:0]  rxBuf_0_irqRxDatWr;

  wire                [rxBuf_0_run1_w-1:0]  rxBuf_0_run1;
  wire              [rxBuf_0_runOut_w-1:0]  rxBuf_0_runOut;
  wire              [rxBuf_0_numOut_w-1:0]  rxBuf_0_numOut;
  wire             [rxBuf_0_fftWrap_w-1:0]  rxBuf_0_fftWrap;
  wire           [rxBuf_0_ssAcqHalt_w-1:0]  rxBuf_0_ssAcqHalt;

  wire                                      rxBuf_0_regWe;
  wire                                      rxBuf_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  rxBuf rxBuf_0(rxBuf_0_y, rxBuf_0_y_or, rxBuf_0_y_ff, rxBuf_0_y_we,
                rxBuf_0_x, rxBuf_0_x_ir, rxBuf_0_x_fe, rxBuf_0_x_re, 
                rxBuf_0_irqRxDatWr, 
                rxBuf_0_run1, 
                rxBuf_0_runOut, 
                rxBuf_0_numOut, 
                rxBuf_0_fftWrap, 
                rxBuf_0_ssAcqHalt, 
                regBus, regWe, regRe, rxBuf_0_regWe, rxBuf_0_regRe, clk, clk2, reset);


//==============================================================================
