//====================================================================================
//  Copyright (C) BAY9, 2016
//====================================================================================
//
// MODULE:
//   rtx80
//
// ----------------------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------

module rtx80(yRx20, yRx20_or, yRx20_ff, yRx20_we, 
             yTx80, yTx80_or, yTx80_ff, yTx80_we, 
             y40, y40_or, y40_ff, y40_we, 
             xTx20, xTx20_ir, xTx20_fe, xTx20_re, 
             xRx80, xRx80_ir, xRx80_fe, xRx80_re, 
             attnDb, attnDb_ir, attnDb_fe, attnDb_re, 
             regBus, regWe, regRe, regWeOut, regReOut, clk1, clk2, reset);

  // --------------------------------------------------------------------------------------
  // Module parameters
  parameter yRx20_w           = 0;
  parameter yTx80_w           = 0;
  parameter y40_w             = 0;
  parameter xTx20_w           = 0;
  parameter xRx80_w           = 0;
  parameter attnDb_w          = 0;


  parameter run1_w            = 0;
  parameter run1_r            = 0;
  parameter run1_s            = 0;
  parameter R_run1            = 0;

  parameter w                 = 0;
  parameter wx                = 0;
  parameter wy                = 0;
  parameter we                = 0;

  // --------------------------------------------------------------------------------------
  // Inputs and outputs
  output        [yRx20_w-1:0]  yRx20;
  output                       yRx20_or;
  input                        yRx20_ff;
  output                       yRx20_we;
  assign                       yRx20_we = yRx20_or & ~yRx20_ff;

  output        [yTx80_w-1:0]  yTx80;
  output                       yTx80_or;
  input                        yTx80_ff;
  output                       yTx80_we;
  assign                       yTx80_we = yTx80_or & ~yTx80_ff;

  output          [y40_w-1:0]  y40;
  output                       y40_or;
  input                        y40_ff;
  output                       y40_we;
  assign                       y40_we = y40_or & ~y40_ff;

  input         [xTx20_w-1:0]  xTx20;
  output                       xTx20_ir;
  input                        xTx20_fe;
  output                       xTx20_re;
  assign                       xTx20_re = xTx20_ir & ~xTx20_fe;

  input         [xRx80_w-1:0]  xRx80;
  output                       xRx80_ir;
  input                        xRx80_fe;
  output                       xRx80_re;
  assign                       xRx80_re = xRx80_ir & ~xRx80_fe;

  input        [attnDb_w-1:0]  attnDb;
  output                       attnDb_ir;
  input                        attnDb_fe;
  output                       attnDb_re;
  assign                       attnDb_re = attnDb_ir & ~attnDb_fe;


  // Define clock and reset
  input                        clk1;
  input                        clk2;
  input                        reset;

  // Inputs and outputs for registers
  inout                [15:0]  regBus;
  input                        regWe;
  input                        regRe;
  output                       regWeOut;
  output                       regReOut;

  // Wires for external registers
  wire           [run1_w-1:0]  run1_q;
  wire           [run1_w-1:0]  run1_d;
  wire                         run1_weint;
  assign                       run1_weint = 0;

  // Assign clock
  wire clk;
  assign clk = clk1;

  // --------------------------------------------------------------------------------------
  // External status registers
  ereg run1(run1_q, regBus, run1_d, run1_weint, regWe, regRe, clk, reset);
  defparam run1.w    = run1_w;
  defparam run1.rval = run1_r;
  defparam run1.sgn  = run1_s;
  defparam run1.adr  = R_run1;

  // --------------------------------------------------------------------------------------
  // Included instances
  `include "scaleTx_0.v"
  `include "scaleRx_0.v"
  `include "wdfSrc_0.v"
  `include "freqShift_0.v"
  `include "s1To2Sel_24a.v"
  `include "s1To2Sel_24b.v"
  `include "s2To1Sel_24a.v"
  `include "s2To1Sel_24b.v"
  `include "buf2_24.v"
  `include "dcOffCorr_0.v"
  `include "iqBuf_0.v"

  // --------------------------------------------------------------------------------------
  // Define connections
  assign scaleTx_0_x               = xTx20;
  assign scaleTx_0_x_fe            = xTx20_fe;
  assign xTx20_ir                  = scaleTx_0_x_ir;

  assign s2To1Sel_24a_x0           = scaleTx_0_y;
  assign s2To1Sel_24a_x0_fe        = ~scaleTx_0_y_or;
  assign scaleTx_0_y_ff            = ~s2To1Sel_24a_x0_ir;

  assign wdfSrc_0_x                = s2To1Sel_24a_y;
  assign wdfSrc_0_x_fe             = ~s2To1Sel_24a_y_or;
  assign s2To1Sel_24a_y_ff         = ~wdfSrc_0_x_ir;

  assign s1To2Sel_24a_x            = wdfSrc_0_y;
  assign s1To2Sel_24a_x_fe         = ~wdfSrc_0_y_or;
  assign wdfSrc_0_y_ff             = ~s1To2Sel_24a_x_ir;

  assign s2To1Sel_24b_x0           = s1To2Sel_24a_y0;
  assign s2To1Sel_24b_x0_fe        = ~s1To2Sel_24a_y0_or;
  assign s1To2Sel_24a_y0_ff        = ~s2To1Sel_24b_x0_ir;

  assign freqShift_0_x             = s2To1Sel_24b_y;
  assign freqShift_0_x_fe          = ~s2To1Sel_24b_y_or;
  assign s2To1Sel_24b_y_ff         = ~freqShift_0_x_ir;

  assign s1To2Sel_24b_x            = freqShift_0_y;
  assign s1To2Sel_24b_x_fe         = ~freqShift_0_y_or;
  assign freqShift_0_y_ff          = ~s1To2Sel_24b_x_ir;

  assign iqBuf_0_xTx               = s1To2Sel_24b_y0;
  assign iqBuf_0_xTx_fe            = ~s1To2Sel_24b_y0_or;
  assign s1To2Sel_24b_y0_ff        = ~iqBuf_0_xTx_ir;

  assign buf2_24_x                 = iqBuf_0_yTx;
  assign buf2_24_x_fe              = ~iqBuf_0_yTx_or;
  assign iqBuf_0_yTx_ff            = ~buf2_24_x_ir;

  assign dcOffCorr_0_xTx           = buf2_24_y;
  assign dcOffCorr_0_xTx_fe        = ~buf2_24_y_or;
  assign buf2_24_y_ff              = ~dcOffCorr_0_xTx_ir;

  assign yTx80                     = dcOffCorr_0_yTx;
  assign yTx80_or                  = dcOffCorr_0_yTx_or;
  assign dcOffCorr_0_yTx_ff        = yTx80_ff;

  assign dcOffCorr_0_attnDb        = attnDb;
  assign dcOffCorr_0_attnDb_fe     = attnDb_fe;
  assign attnDb_ir                 = dcOffCorr_0_attnDb_ir;

  assign dcOffCorr_0_xRx           = xRx80;
  assign dcOffCorr_0_xRx_fe        = xRx80_fe;
  assign xRx80_ir                  = dcOffCorr_0_xRx_ir;

  assign iqBuf_0_xRx               = dcOffCorr_0_yRx;
  assign iqBuf_0_xRx_fe            = ~dcOffCorr_0_yRx_or;
  assign dcOffCorr_0_yRx_ff        = ~iqBuf_0_xRx_ir;

  assign s2To1Sel_24b_x1           = iqBuf_0_yRx;
  assign s2To1Sel_24b_x1_fe        = ~iqBuf_0_yRx_or;
  assign iqBuf_0_yRx_ff            = ~s2To1Sel_24b_x1_ir;

  assign s2To1Sel_24a_x1           = s1To2Sel_24b_y1;
  assign s2To1Sel_24a_x1_fe        = ~s1To2Sel_24b_y1_or;
  assign s1To2Sel_24b_y1_ff        = ~s2To1Sel_24a_x1_ir;

  assign scaleRx_0_x               = s1To2Sel_24a_y1;
  assign scaleRx_0_x_fe            = ~s1To2Sel_24a_y1_or;
  assign s1To2Sel_24a_y1_ff        = ~scaleRx_0_x_ir;

  assign yRx20                     = scaleRx_0_y;
  assign yRx20_or                  = scaleRx_0_y_or;
  assign scaleRx_0_y_ff            = yRx20_ff;

  assign y40                       = wdfSrc_0_y40;
  assign y40_or                    = wdfSrc_0_y40_or;
  assign wdfSrc_0_y40_ff           = y40_ff;


  // --------------------------------------------------------------------------------------
  // Define register control output
  assign regWeOut = 0 | scaleTx_0_regWe | scaleRx_0_regWe | wdfSrc_0_regWe
                      | freqShift_0_regWe | s1To2Sel_24a_regWe | s1To2Sel_24b_regWe
                      | s2To1Sel_24a_regWe | s2To1Sel_24b_regWe | buf2_24_regWe
                      | dcOffCorr_0_regWe | iqBuf_0_regWe;
  assign regReOut = 0 | scaleTx_0_regRe | scaleRx_0_regRe | wdfSrc_0_regRe
                      | freqShift_0_regRe | s1To2Sel_24a_regRe | s1To2Sel_24b_regRe
                      | s2To1Sel_24a_regRe | s2To1Sel_24b_regRe | buf2_24_regRe
                      | dcOffCorr_0_regRe | iqBuf_0_regRe;

// ----------------------------------------------------------------------------------------
//=========================================================================================

  // --------------------------------------------------------------------------------------
  // Set run from input directly
  assign scaleTx_0_run1   = run1_q!=0;
  assign wdfSrc_0_run1    = run1_q;
  assign freqShift_0_run1 = run1_q;
  assign dcOffCorr_0_run1 = run1_q;
  assign buf2_24_run1     = run1_q==2;
  
  // Set switches
  assign s1To2Sel_24a_sel = run1_q==3;
  assign s1To2Sel_24b_sel = run1_q==3;
  assign s2To1Sel_24a_sel = run1_q==3;
  assign s2To1Sel_24b_sel = run1_q==3;
    
endmodule
//=========================================================================================

