//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter qamMod_0_x_w             = 1;

  // Outputs
  parameter qamMod_0_y_w             = 20;

  // Input control lines
  parameter qamMod_0_run1_w          = 2;

  // Output control lines
  parameter qamMod_0_irqHdrDone_w    = 1;

  // Eregs
  parameter qamMod_0_mode1_w         = 2;
  parameter qamMod_0_mode1_r         = 0;
  parameter qamMod_0_mode1_s         = 0;

  // Parameters
  parameter qamMod_0_w               = 10;
  parameter qamMod_0_bpskL1          = 128;
  parameter qamMod_0_qam4L1          = 91;
  parameter qamMod_0_qam16L1         = 41;
  parameter qamMod_0_qam16L3         = 122;
  parameter qamMod_0_qam64L1         = 20;
  parameter qamMod_0_qam64L3         = 59;
  parameter qamMod_0_qam64L5         = 99;
  parameter qamMod_0_qam64L7         = 139;

  // Iregs

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam qamMod_0.x_w             = qamMod_0_x_w;
  defparam qamMod_0.y_w             = qamMod_0_y_w;
  defparam qamMod_0.run1_w          = qamMod_0_run1_w;
  defparam qamMod_0.irqHdrDone_w    = qamMod_0_irqHdrDone_w;
  defparam qamMod_0.mode1_w         = qamMod_0_mode1_w;
  defparam qamMod_0.mode1_r         = qamMod_0_mode1_r;
  defparam qamMod_0.mode1_s         = qamMod_0_mode1_s;
  defparam qamMod_0.w               = qamMod_0_w;
  defparam qamMod_0.bpskL1          = qamMod_0_bpskL1;
  defparam qamMod_0.qam4L1          = qamMod_0_qam4L1;
  defparam qamMod_0.qam16L1         = qamMod_0_qam16L1;
  defparam qamMod_0.qam16L3         = qamMod_0_qam16L3;
  defparam qamMod_0.qam64L1         = qamMod_0_qam64L1;
  defparam qamMod_0.qam64L3         = qamMod_0_qam64L3;
  defparam qamMod_0.qam64L5         = qamMod_0_qam64L5;
  defparam qamMod_0.qam64L7         = qamMod_0_qam64L7;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_qamMod_0_mode1                                             = 0;
  defparam  qamMod_0.R_mode1                                             = R_qamMod_0_mode1;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [qamMod_0_y_w-1:0]  qamMod_0_y;
  wire                                      qamMod_0_y_or;
  wire                                      qamMod_0_y_ff;
  wire                                      qamMod_0_y_we;

  wire                  [qamMod_0_x_w-1:0]  qamMod_0_x;
  wire                                      qamMod_0_x_ir;
  wire                                      qamMod_0_x_fe;
  wire                                      qamMod_0_x_re;

  wire         [qamMod_0_irqHdrDone_w-1:0]  qamMod_0_irqHdrDone;

  wire               [qamMod_0_run1_w-1:0]  qamMod_0_run1;

  wire                                      qamMod_0_regWe;
  wire                                      qamMod_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  qamMod qamMod_0(qamMod_0_y, qamMod_0_y_or, qamMod_0_y_ff, qamMod_0_y_we,
                  qamMod_0_x, qamMod_0_x_ir, qamMod_0_x_fe, qamMod_0_x_re, 
                  qamMod_0_irqHdrDone, 
                  qamMod_0_run1, 
                  regBus, regWe, regRe, qamMod_0_regWe, qamMod_0_regRe, clk, clk2, reset);


//==============================================================================
