//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter ppdu11a_0_x_w             = 1;

  // Outputs
  parameter ppdu11a_0_ys_w            = 2;

  // Input control lines
  parameter ppdu11a_0_run1_w          = 2;

  // Output control lines
  parameter ppdu11a_0_irqHdrDone_w    = 1;

  // Eregs
  parameter ppdu11a_0_plcpHdr0_w      = 16;
  parameter ppdu11a_0_plcpHdr0_r      = 0;
  parameter ppdu11a_0_plcpHdr0_s      = 0;
  parameter ppdu11a_0_plcpHdr1_w      = 2;
  parameter ppdu11a_0_plcpHdr1_r      = 0;
  parameter ppdu11a_0_plcpHdr1_s      = 0;
  parameter ppdu11a_0_numByte_w       = 12;
  parameter ppdu11a_0_numByte_r       = 0;
  parameter ppdu11a_0_numByte_s       = 0;
  parameter ppdu11a_0_numPadBit_w     = 9;
  parameter ppdu11a_0_numPadBit_r     = 0;
  parameter ppdu11a_0_numPadBit_s     = 0;

  // Parameters
  parameter ppdu11a_0_StReset         = 0;
  parameter ppdu11a_0_StHdr           = 1;
  parameter ppdu11a_0_StHdrDone       = 2;
  parameter ppdu11a_0_StPsduService   = 3;
  parameter ppdu11a_0_StPsduData      = 4;
  parameter ppdu11a_0_StPsduTail      = 5;
  parameter ppdu11a_0_StPsduPad       = 6;
  parameter ppdu11a_0_NumHdrData      = 24;
  parameter ppdu11a_0_NumPsduService  = 16;
  parameter ppdu11a_0_NumPsduTail     = 6;

  // Iregs
  parameter ppdu11a_0_state_w         = 3;
  parameter ppdu11a_0_state_n         = 1;
  parameter ppdu11a_0_state_m         = `CLOG2(1);
  parameter ppdu11a_0_cnt_w           = 15;
  parameter ppdu11a_0_cnt_n           = 1;
  parameter ppdu11a_0_cnt_m           = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam ppdu11a_0.x_w             = ppdu11a_0_x_w;
  defparam ppdu11a_0.ys_w            = ppdu11a_0_ys_w;
  defparam ppdu11a_0.run1_w          = ppdu11a_0_run1_w;
  defparam ppdu11a_0.irqHdrDone_w    = ppdu11a_0_irqHdrDone_w;
  defparam ppdu11a_0.plcpHdr0_w      = ppdu11a_0_plcpHdr0_w;
  defparam ppdu11a_0.plcpHdr0_r      = ppdu11a_0_plcpHdr0_r;
  defparam ppdu11a_0.plcpHdr0_s      = ppdu11a_0_plcpHdr0_s;
  defparam ppdu11a_0.plcpHdr1_w      = ppdu11a_0_plcpHdr1_w;
  defparam ppdu11a_0.plcpHdr1_r      = ppdu11a_0_plcpHdr1_r;
  defparam ppdu11a_0.plcpHdr1_s      = ppdu11a_0_plcpHdr1_s;
  defparam ppdu11a_0.numByte_w       = ppdu11a_0_numByte_w;
  defparam ppdu11a_0.numByte_r       = ppdu11a_0_numByte_r;
  defparam ppdu11a_0.numByte_s       = ppdu11a_0_numByte_s;
  defparam ppdu11a_0.numPadBit_w     = ppdu11a_0_numPadBit_w;
  defparam ppdu11a_0.numPadBit_r     = ppdu11a_0_numPadBit_r;
  defparam ppdu11a_0.numPadBit_s     = ppdu11a_0_numPadBit_s;
  defparam ppdu11a_0.StReset         = ppdu11a_0_StReset;
  defparam ppdu11a_0.StHdr           = ppdu11a_0_StHdr;
  defparam ppdu11a_0.StHdrDone       = ppdu11a_0_StHdrDone;
  defparam ppdu11a_0.StPsduService   = ppdu11a_0_StPsduService;
  defparam ppdu11a_0.StPsduData      = ppdu11a_0_StPsduData;
  defparam ppdu11a_0.StPsduTail      = ppdu11a_0_StPsduTail;
  defparam ppdu11a_0.StPsduPad       = ppdu11a_0_StPsduPad;
  defparam ppdu11a_0.NumHdrData      = ppdu11a_0_NumHdrData;
  defparam ppdu11a_0.NumPsduService  = ppdu11a_0_NumPsduService;
  defparam ppdu11a_0.NumPsduTail     = ppdu11a_0_NumPsduTail;
  defparam ppdu11a_0.state_w         = ppdu11a_0_state_w;
  defparam ppdu11a_0.state_n         = ppdu11a_0_state_n;
  defparam ppdu11a_0.state_m         = ppdu11a_0_state_m;
  defparam ppdu11a_0.cnt_w           = ppdu11a_0_cnt_w;
  defparam ppdu11a_0.cnt_n           = ppdu11a_0_cnt_n;
  defparam ppdu11a_0.cnt_m           = ppdu11a_0_cnt_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_ppdu11a_0_plcpHdr0                                         = 0;
  defparam  ppdu11a_0.R_plcpHdr0                                         = R_ppdu11a_0_plcpHdr0;
  parameter R_ppdu11a_0_plcpHdr1                                         = 1;
  defparam  ppdu11a_0.R_plcpHdr1                                         = R_ppdu11a_0_plcpHdr1;
  parameter R_ppdu11a_0_numByte                                          = 2;
  defparam  ppdu11a_0.R_numByte                                          = R_ppdu11a_0_numByte;
  parameter R_ppdu11a_0_numPadBit                                        = 3;
  defparam  ppdu11a_0.R_numPadBit                                        = R_ppdu11a_0_numPadBit;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                [ppdu11a_0_ys_w-1:0]  ppdu11a_0_ys;
  wire                                      ppdu11a_0_ys_or;
  wire                                      ppdu11a_0_ys_ff;
  wire                                      ppdu11a_0_ys_we;

  wire                 [ppdu11a_0_x_w-1:0]  ppdu11a_0_x;
  wire                                      ppdu11a_0_x_ir;
  wire                                      ppdu11a_0_x_fe;
  wire                                      ppdu11a_0_x_re;

  wire        [ppdu11a_0_irqHdrDone_w-1:0]  ppdu11a_0_irqHdrDone;

  wire              [ppdu11a_0_run1_w-1:0]  ppdu11a_0_run1;

  wire                                      ppdu11a_0_regWe;
  wire                                      ppdu11a_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  ppdu11a ppdu11a_0(ppdu11a_0_ys, ppdu11a_0_ys_or, ppdu11a_0_ys_ff, ppdu11a_0_ys_we,
                    ppdu11a_0_x, ppdu11a_0_x_ir, ppdu11a_0_x_fe, ppdu11a_0_x_re, 
                    ppdu11a_0_irqHdrDone, 
                    ppdu11a_0_run1, 
                    regBus, regWe, regRe, ppdu11a_0_regWe, ppdu11a_0_regRe, clk, clk2, reset);


//==============================================================================
