//==============================================================================
//  Copyright (C) BAY9, 2016
//==============================================================================

  // ---------------------------------------------------------------------------
  // CLOG2 workaround for Xilinx ISE
  `include "clog2.v"

  // ---------------------------------------------------------------------------
  // Parameter definitions

  // Inputs
  parameter pltExt_0_x_w             = 22;

  // Outputs
  parameter pltExt_0_y_w             = 22;

  // Input control lines
  parameter pltExt_0_run1_w          = 1;

  // Output control lines
  parameter pltExt_0_irqDone_w       = 1;

  // Eregs
  parameter pltExt_0_pltSumRe_w      = 13;
  parameter pltExt_0_pltSumRe_r      = 0;
  parameter pltExt_0_pltSumRe_s      = 1;
  parameter pltExt_0_pltSumIm_w      = 13;
  parameter pltExt_0_pltSumIm_r      = 0;
  parameter pltExt_0_pltSumIm_s      = 1;

  // Parameters
  parameter pltExt_0_w               = 11;

  // Iregs
  parameter pltExt_0_pltScr_w        = 7;
  parameter pltExt_0_pltScr_n        = 1;
  parameter pltExt_0_pltScr_m        = `CLOG2(1);

  // Single ported memories

  // Dual ported memories

  // Fifos

  // Wires

  // ---------------------------------------------------------------------------
  // Set parameters
  defparam pltExt_0.x_w             = pltExt_0_x_w;
  defparam pltExt_0.y_w             = pltExt_0_y_w;
  defparam pltExt_0.run1_w          = pltExt_0_run1_w;
  defparam pltExt_0.irqDone_w       = pltExt_0_irqDone_w;
  defparam pltExt_0.pltSumRe_w      = pltExt_0_pltSumRe_w;
  defparam pltExt_0.pltSumRe_r      = pltExt_0_pltSumRe_r;
  defparam pltExt_0.pltSumRe_s      = pltExt_0_pltSumRe_s;
  defparam pltExt_0.pltSumIm_w      = pltExt_0_pltSumIm_w;
  defparam pltExt_0.pltSumIm_r      = pltExt_0_pltSumIm_r;
  defparam pltExt_0.pltSumIm_s      = pltExt_0_pltSumIm_s;
  defparam pltExt_0.w               = pltExt_0_w;
  defparam pltExt_0.pltScr_w        = pltExt_0_pltScr_w;
  defparam pltExt_0.pltScr_n        = pltExt_0_pltScr_n;
  defparam pltExt_0.pltScr_m        = pltExt_0_pltScr_m;

  // ---------------------------------------------------------------------------
  // EREG address definitions - might be overwritten by an upper module
  parameter R_pltExt_0_pltSumRe                                          = 0;
  defparam  pltExt_0.R_pltSumRe                                          = R_pltExt_0_pltSumRe;
  parameter R_pltExt_0_pltSumIm                                          = 1;
  defparam  pltExt_0.R_pltSumIm                                          = R_pltExt_0_pltSumIm;

  // FIFO address definitions - might be overwritten by an upper module

  // ---------------------------------------------------------------------------
  // Wires for module interface
  wire                  [pltExt_0_y_w-1:0]  pltExt_0_y;
  wire                                      pltExt_0_y_or;
  wire                                      pltExt_0_y_ff;
  wire                                      pltExt_0_y_we;

  wire                  [pltExt_0_x_w-1:0]  pltExt_0_x;
  wire                                      pltExt_0_x_ir;
  wire                                      pltExt_0_x_fe;
  wire                                      pltExt_0_x_re;

  wire            [pltExt_0_irqDone_w-1:0]  pltExt_0_irqDone;

  wire               [pltExt_0_run1_w-1:0]  pltExt_0_run1;

  wire                                      pltExt_0_regWe;
  wire                                      pltExt_0_regRe;

  // ---------------------------------------------------------------------------
  // Instance definition
  pltExt pltExt_0(pltExt_0_y, pltExt_0_y_or, pltExt_0_y_ff, pltExt_0_y_we,
                  pltExt_0_x, pltExt_0_x_ir, pltExt_0_x_fe, pltExt_0_x_re, 
                  pltExt_0_irqDone, 
                  pltExt_0_run1, 
                  regBus, regWe, regRe, pltExt_0_regWe, pltExt_0_regRe, clk, clk2, reset);


//==============================================================================
